/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.aspectj.CustomCodePositionReport;
import cn.com.duiba.developer.center.api.aspectj.CustomCodeReportRunner;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@ConditionalOnClass(value={WhiteAccessUtil.class})
@ConditionalOnProperty(name={"white.list.reportCodeopenSwitch"}, havingValue="1", matchIfMissing=false)
public class CustomReportCollectBeanPostProccess
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(CustomReportCollectBeanPostProccess.class);
    @Autowired
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return bean;
        }
        try {
            String sysName = this.environment.getProperty("spring.application.name");
            CustomReportCollectBeanPostProccess.initMethodByAnnotation(bean, sysName);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u6536\u96c6CustomCodePositionReport \u6ce8\u89e3\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static void initMethodByAnnotation(Object bean, String sysName) {
        Method[] methods;
        Class aClass = AopUtils.getTargetClass((Object)bean);
        CustomCodePositionReport customCodePositionReport = aClass.getDeclaredAnnotation(CustomCodePositionReport.class);
        if (customCodePositionReport != null) {
            CustomCodeReportRunner.collectPositionObject(sysName, aClass.getName(), customCodePositionReport.description(), customCodePositionReport.value(), CustomCodeReportRunner.whiteListCodePositions);
        }
        if (null != (methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass()))) {
            for (Method method : methods) {
                CustomCodePositionReport methodPositionReport = (CustomCodePositionReport)AnnotationUtils.findAnnotation((Method)method, CustomCodePositionReport.class);
                if (null == methodPositionReport) continue;
                String packagePath = aClass.getName() + "." + method.getName();
                String description = methodPositionReport.description();
                String value = methodPositionReport.value();
                CustomCodeReportRunner.collectPositionObject(sysName, packagePath, description, value, CustomCodeReportRunner.whiteListCodePositions);
            }
        }
    }
}

