/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.aspectj.CustomCodePositionReport;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListContentDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.BusinessWhiteListDto;
import cn.com.duiba.developer.center.api.domain.enums.authority.AccessStatusType;
import cn.com.duiba.developer.center.api.domain.enums.authority.BusinessWhiteListType;
import cn.com.duiba.developer.center.api.remoteservice.authority.RemoteBusinessWhiteListContentService;
import cn.com.duiba.developer.center.api.remoteservice.authority.RemoteBusinessWhiteListService;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="whiteAccessUtil")
public class WhiteAccessUtilBase
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(WhiteAccessUtilBase.class);
    @Autowired
    private RemoteBusinessWhiteListContentService remoteBusinessWhiteListContentService;
    @Autowired
    private RemoteBusinessWhiteListService remoteBusinessWhiteListService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    private static String EXITST = "1";
    private static String NOT_EXITST = "0";
    public static String PREFIX = "WHITE_LIST_";
    public static String PREFIX_SINGLE = "WHITE_LIST_SINGLE";
    public static String PREFIX_JSON = "WHITE_LIST_JSON";
    private static final Cache<String, Boolean> CAN_ACCESS_WHITE_LIST = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private static final Cache<String, String> WHITE_LIST_JSON_VALUE = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private static final Cache<String, List<String>> WHITE_LIST_VALUES = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1000L).build();

    public void afterPropertiesSet() throws Exception {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget((Object)this);
        proxyFactory.addAdvice((Advice)new WhiteAccessMethodInterceptor());
        WhiteAccessUtil.whiteAccessUtilBase = (WhiteAccessUtilBase)proxyFactory.getProxy();
        logger.info("WhiteAccessUtilBase \u4ee3\u7406\u8bbe\u7f6e\u5b8c\u6bd5");
    }

    public String selectWhiteListJsonConfig(String uniqueCode) {
        return (String)WHITE_LIST_JSON_VALUE.get((Object)uniqueCode, code -> {
            String uniqueCodeKey = PREFIX_JSON + code;
            try {
                String jsonValue = (String)this.stringRedisTemplate.opsForValue().get((Object)uniqueCodeKey);
                if (jsonValue == null) {
                    BusinessWhiteListDto whiteListConfig = this.remoteBusinessWhiteListService.getByCode((String)code);
                    if (whiteListConfig == null || !BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.warn("WHITE_LIST_JSON_VALUE  \u9519\u8bef \u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return null;
                    }
                    BusinessWhiteListContentDto dto = this.remoteBusinessWhiteListContentService.getByRelId(whiteListConfig.getId());
                    if (dto != null && StringUtils.isNotBlank((CharSequence)dto.getBizContent())) {
                        this.stringRedisTemplate.opsForValue().set((Object)uniqueCodeKey, (Object)dto.getBizContent());
                        this.stringRedisTemplate.expire((Object)uniqueCode, 12L, TimeUnit.HOURS);
                        return dto.getBizContent();
                    }
                    return null;
                }
                return jsonValue;
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", code, (Object)e);
                return null;
            }
        });
    }

    public Boolean matchWhiteList(Long appId, String uniqueCode) {
        String appIdCode = appId.toString() + "#" + uniqueCode;
        return (Boolean)CAN_ACCESS_WHITE_LIST.get((Object)appIdCode, appIdCodeStr -> {
            String[] data = appIdCodeStr.split("#");
            String code = data[1];
            String appIdStr = data[0];
            String uniqueCodeKey = PREFIX_SINGLE + code;
            try {
                Object score = this.stringRedisTemplate.opsForHash().get((Object)uniqueCodeKey, (Object)appIdStr);
                if (score == null) {
                    BusinessWhiteListDto whiteListConfig = this.remoteBusinessWhiteListService.getByCode(code);
                    if (whiteListConfig == null || AccessStatusType.CLOSE.getCode().equals(whiteListConfig.getOpenStatus()) || BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.info("\u767d\u540d\u5355\u7c7b\u578b\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9 queryParam = {}", appIdCodeStr);
                        this.stringRedisTemplate.opsForHash().put((Object)uniqueCodeKey, (Object)appIdStr, (Object)NOT_EXITST);
                        return false;
                    }
                    Boolean wasExist = this.remoteBusinessWhiteListContentService.getByRelIdAndValue(whiteListConfig.getId(), appId) != null;
                    this.stringRedisTemplate.opsForHash().put((Object)uniqueCodeKey, (Object)appIdStr, (Object)(wasExist != false ? EXITST : NOT_EXITST));
                    this.stringRedisTemplate.expire((Object)uniqueCodeKey, 12L, TimeUnit.HOURS);
                    return wasExist;
                }
                return EXITST.equals(String.valueOf(score));
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", appIdCodeStr, (Object)e);
                return false;
            }
        });
    }

    public List<String> selectWhiteListConfig(String uniqueCode) {
        return (List)WHITE_LIST_VALUES.get((Object)uniqueCode, code -> {
            String uniqueCodeKey = PREFIX + code;
            try {
                String jsonValue = (String)this.stringRedisTemplate.opsForValue().get((Object)uniqueCodeKey);
                if (jsonValue == null) {
                    ArrayList values = Lists.newArrayList();
                    BusinessWhiteListDto whiteListConfig = this.remoteBusinessWhiteListService.getByCode((String)code);
                    if (whiteListConfig == null) {
                        logger.warn("fetchWhiteListValues code \u9519\u8bef \u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return values;
                    }
                    if (BusinessWhiteListType.JSON_VALUE.getCode().equals(whiteListConfig.getBizType())) {
                        logger.warn("WHITE_LIST_JSON_VALUE \u767d\u540d\u5355json\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9 queryParam = {}", code);
                        return values;
                    }
                    List<BusinessWhiteListContentDto> dtos = this.remoteBusinessWhiteListContentService.getByRid(whiteListConfig.getId());
                    if (CollectionUtils.isNotEmpty(dtos)) {
                        values.addAll(dtos.stream().map(a -> a.getRelValue()).collect(Collectors.toList()));
                        this.stringRedisTemplate.opsForValue().set((Object)uniqueCodeKey, (Object)JSON.toJSONString((Object)values));
                        this.stringRedisTemplate.expire((Object)uniqueCodeKey, 12L, TimeUnit.HOURS);
                    }
                    return values;
                }
                return JSONArray.parseArray((String)jsonValue, String.class);
            }
            catch (Exception e) {
                logger.warn("\u767d\u540d\u5355\u67e5\u8be2\u5931\u8d25\u3002\u8d70\u9ed8\u8ba4\u964d\u7ea7\u7b56\u7565 false equryParam = {}", code, (Object)e);
                return Lists.newArrayList();
            }
        });
    }

    public static class QueryParam {
        private Long appId;
        private String uniqueCode;

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public String getUniqueCode() {
            return this.uniqueCode;
        }

        public void setUniqueCode(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }

        public QueryParam(Long appId, String uniqueCode) {
            this.appId = appId;
            this.uniqueCode = uniqueCode;
        }

        public QueryParam(String uniqueCode) {
            this.uniqueCode = uniqueCode;
        }
    }

    private static class WhiteAccessMethodInterceptor
    implements MethodInterceptor {
        private WhiteAccessMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method[] declaredMethods;
            if (SpringEnvironmentUtils.isProdEnv()) {
                return invocation.proceed();
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElementCur = null;
            for (int i = 0; i < stackTrace.length; ++i) {
                if (!stackTrace[i].getClassName().equals("cn.com.duiba.developer.center.api.utils.WhiteAccessUtil") || !stackTrace[i].getFileName().equals("WhiteAccessUtil.java")) continue;
                stackTraceElementCur = stackTrace[i + 1];
                break;
            }
            String methodName = stackTraceElementCur.getMethodName();
            String className = stackTraceElementCur.getClassName();
            Class<?> aClass = Class.forName(className);
            CustomCodePositionReport classCustomCodePositionReport = aClass.getDeclaredAnnotation(CustomCodePositionReport.class);
            if (classCustomCodePositionReport != null) {
                return invocation.proceed();
            }
            for (Method declaredMethod : declaredMethods = aClass.getDeclaredMethods()) {
                CustomCodePositionReport methodPositionReport;
                if (!declaredMethod.getName().equals(methodName) || (methodPositionReport = (CustomCodePositionReport)AnnotationUtils.findAnnotation((Method)declaredMethod, CustomCodePositionReport.class)) == null) continue;
                return invocation.proceed();
            }
            throw new RuntimeException("WhiteAccessUtil \u6240\u5728\u7c7b\u6216\u8005\u65b9\u6cd5\u9700\u8981\u914d\u7f6eCustomCodePositionReport\u4e00\u8d77\u4f7f\u7528\uff01");
        }
    }
}

