package cn.com.duiba.developer.center.api.domain.dto.saas;

import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.VersionProfitTypeEnum;

import java.util.Date;

/**
 * @author xiaoxuda 2018/07/31
 */
public class SaasItemDto implements java.io.Serializable {
    private static final long serialVersionUID = 5454155825314635342L;

    /**id**/
    private Long id;

    /**商品名称**/
    private String name;

    /**saas功能类型，参考SaasFuncTypeEnum**/
    private SaasFuncTypeEnum funcType;

    /**saas功能子类型**/
    private Integer funcSubType;

    /**功能子类型ID**/
    private Long funcRelId;

    /**使用教程链接**/
    private String courseUrl;

    /**简介**/
    private String description;

    /**版本权益类型,0：无版本权益，1：:统一版本权益，2：自定义版本价格**/
    private VersionProfitTypeEnum versionProfitType;

    /**购买限制**/
    private Boolean buyLimitOpen;

    /**购买数量限制**/
    private Integer buyLimitCount;

    /**版本限购配置，格式{versionCode:true/false}**/
    private String buyLimitVersionJson;

    /**图标**/
    private String logo;

    /**动态图标**/
    private String dynamicLogo;

    /**图文描述地址**/
    private Integer price;

    /**上架状态**/
    private Boolean openStatus;

    /**
     * 图文详情链接
     */
    private String detailUrl;

    /**创建时间**/
    private Date gmtCreate;

    /**更新时间**/
    private Date gmtModified;

    /**销售数量**/
    private Integer saleCount;


    public Integer getSaleCount() {
        return saleCount;
    }

    public void setSaleCount(Integer saleCount) {
        this.saleCount = saleCount;
    }

    public void setId(Long value) {
        this.id = value;
    }

    public Long getId() {
        return this.id;
    }
    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public SaasFuncTypeEnum getFuncType() {
        return funcType;
    }

    public void setFuncType(SaasFuncTypeEnum funcType) {
        this.funcType = funcType;
    }

    public void setFuncSubType(Integer value) {
        this.funcSubType = value;
    }

    public Integer getFuncSubType() {
        return this.funcSubType;
    }
    public void setFuncRelId(Long value) {
        this.funcRelId = value;
    }

    public Long getFuncRelId() {
        return this.funcRelId;
    }

    public String getCourseUrl() {
        return courseUrl;
    }

    public void setCourseUrl(String courseUrl) {
        this.courseUrl = courseUrl;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public VersionProfitTypeEnum getVersionProfitType() {
        return versionProfitType;
    }

    public void setVersionProfitType(VersionProfitTypeEnum versionProfitType) {
        this.versionProfitType = versionProfitType;
    }

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    public void setBuyLimitOpen(Boolean value) {
        this.buyLimitOpen = value;
    }

    public Boolean getBuyLimitOpen() {
        return this.buyLimitOpen;
    }
    public void setBuyLimitCount(Integer value) {
        this.buyLimitCount = value;
    }

    public Integer getBuyLimitCount() {
        return this.buyLimitCount;
    }
    public void setBuyLimitVersionJson(String value) {
        this.buyLimitVersionJson = value;
    }

    public String getBuyLimitVersionJson() {
        return this.buyLimitVersionJson;
    }
    public void setLogo(String value) {
        this.logo = value;
    }

    public String getLogo() {
        return this.logo;
    }
    public void setDynamicLogo(String value) {
        this.dynamicLogo = value;
    }

    public String getDynamicLogo() {
        return this.dynamicLogo;
    }
    public void setPrice(Integer value) {
        this.price = value;
    }

    public Integer getPrice() {
        return this.price;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public void setGmtCreate(Date value) {
        this.gmtCreate = value;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }
    public void setGmtModified(Date value) {
        this.gmtModified = value;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }


}