package cn.com.duiba.developer.center.api.domain.dto.survey;

import cn.com.duiba.developer.center.api.domain.enums.survey.OptionTypeEnum;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 问题的选项
 */
public class OptionDto implements Serializable {
    private static final long serialVersionUID = -7622149319482291112L;
    /**
     * ID
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 问题Id
     */
    private Long questionId;
    /**
     * 编码,同一问题下唯一
     */
    @Size(max = 50, message = "选项编码长度不正确")
    @NotNull(message = "选项编码必填")
    private String code;

    /**
     * 选项标题
     */
    @Size(max = 50, message = "选项标题")
    @NotNull
    private String title;

    /**
     * 类型，主要用区分其他
     * {@link OptionTypeEnum}
     */
    @NotNull
    private String type;
    /**
     * 展示其他隐藏的题目
     * {@link String[]}
     */
    private String display = "[]";

    /**
     * 跳转
     */
    private String jump;
    /**
     * 是否互斥
     * 用于多选的多个选项
     */
    private Boolean exclusive = false;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getQuestionId() {
        return questionId;
    }

    public void setQuestionId(Long questionId) {
        this.questionId = questionId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Boolean getExclusive() {
        return exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String getJump() {
        return jump;
    }

    public void setJump(String jump) {
        this.jump = jump;
    }
}
