package cn.com.duiba.developer.center.api.domain.enums;

/**
 * Created by xiaoxuda on 2016/11/15.
 */
public enum VipLimitTypeEnum {
    OFF_LEVEL(0, "未开启vip等级限制"),
    ACCURATE_LEVEL(1, "指定vip等级可通过"),
    ABOVE_LEVEL(2, "指定vip等级及以上等级可通过");

    private Integer code;
    private String desc;

    VipLimitTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 通过code获取枚举值
     *
     * @param code
     * @return
     */
    public VipLimitTypeEnum getByCode(Integer code) {
        for (VipLimitTypeEnum vlt : VipLimitTypeEnum.values()) {
            if (vlt.getCode().equals(code)) {
                return vlt;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
