package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/25.
 */
public enum OrderSourceEnum {
    /**
     * 订单来源,1:线上(开发者创建),2:代理商添加,3:手动添加（兑吧管理员）
     * orderSource
     */
    FROM_DEVELOPER(1,"线上"),
    FROM_AGENT(2,"代理商添加"),
    FROM_ADMIN(3,"手动添加");

    private static final Map<Integer, OrderSourceEnum> enumMap = new HashMap<>();
    static{
        for(OrderSourceEnum orderSourceEnum : values()){
            enumMap.put(orderSourceEnum.getValue(), orderSourceEnum);
        }
    }

    public static OrderSourceEnum getByCode(Integer code){
        OrderSourceEnum orderSourceEnum = enumMap.get(code);
        if(orderSourceEnum == null){
            throw new DeveloperCenterException("不支持的进度类型");
        }
        return orderSourceEnum;
    }

    private int    value;
    private String desc;

    OrderSourceEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }


}
