package cn.com.duiba.developer.center.api.domain.param;

import cn.com.duiba.developer.center.api.domain.enums.visualeditor.UnitTypeEnum;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

import java.io.Serializable;

/**
 * @author JunAngLiu
 * @Title: VisualUnitChangePrama
 * @Description:
 * @date 2018/12/310:10
 */
public class VisualUnitChangePrama implements Serializable {

    private static final long serialVersionUID = 9142762013052533937L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 组件名称
     * isNullAble:1
     */
    private String unitName;

    /**
     * 组件分类
     * isNullAble:0,defaultVal:0
     */
    private Integer unitGroupCode;

    /**
     * 组件属性 枚举（入参）
     * notNull
     */
    private UnitTypeEnum unitTypeEnum;

    /**
     * 组件key,前端使用,唯一
     */
    private String unitKey;
    /**
     * 组件配置数据
     */
    private String configDataJson;
    /**
     * 上下架标识( 0-隐藏 1-开启)
     */
    private Integer openStatus;
    /**
     * 定向状态(0-公用 1-定向)
     */
    private Integer direction;
    /**
     * 修改人id
     */
    private Long modifyAdminId;

    /**
     * 修改人
     */
    private String modifyName;
    /**
     * 组件url
     * isNullAble:1
     */
    private String unitUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getUnitGroupCode() {
        return unitGroupCode;
    }

    public void setUnitGroupCode(Integer unitGroupCode) {
        this.unitGroupCode = unitGroupCode;
    }

    public UnitTypeEnum getUnitTypeEnum() {
        return unitTypeEnum;
    }

    public void setUnitTypeEnum(UnitTypeEnum unitTypeEnum) {
        this.unitTypeEnum = unitTypeEnum;
    }

    public String getUnitKey() {
        return unitKey;
    }

    public void setUnitKey(String unitKey) {
        this.unitKey = unitKey;
    }

    public String getConfigDataJson() {
        return configDataJson;
    }

    public void setConfigDataJson(String configDataJson) {
        this.configDataJson = configDataJson;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getDirection() {
        return direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public Long getModifyAdminId() {
        return modifyAdminId;
    }

    public void setModifyAdminId(Long modifyAdminId) {
        this.modifyAdminId = modifyAdminId;
    }

    public String getModifyName() {
        return modifyName;
    }

    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    public String getUnitUrl() {
        return unitUrl;
    }

    public void setUnitUrl(String unitUrl) {
        this.unitUrl = unitUrl;
    }


    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
