package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.url.*;
import cn.com.duiba.developer.center.api.domain.paramquery.domain.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNewDomainService {


    boolean careteNewDomain(String url, Integer status) throws BizException;

    boolean updateNewDomain (Integer status, Long id);

    boolean deleteNewDomain (Long id) throws BizException;

    /**
     * 根据条件分页查询新域名
     * @param newDomainQueryParams
     * @return
     */
    Page<NewDomainUrlDto> seachNewDomain (NewDomainQueryParams newDomainQueryParams);

    /**
     * 根据id 查询app信息
     * @return
     */
    List<AppLabelDetailDto> queryAppByUrlId(Long newDomainId, Long labelId);


    /**
     * 创建标签
     * @param params
     * @return
     * @throws BizException
     */
    boolean careteLabel(NewDomainLabelParams params) throws BizException;

    /**
     * 修改标签
     * @param params
     * @return
     * @throws BizException
     */
    boolean updateLabel(NewDomainLabelParams params) throws BizException;

    /**
     * 删除标签
     * @param id
     * @return
     */
    boolean deleteLabel(Long id) throws BizException;

    /**
     * 分页筛选处查询标签
     * @param params
     * @return
     */
    Page<LabelDto> seachLabel(LabelQueryParams params);

    /**
     * 查询可用域名列表
     * @param id
     * @return
     */
    List<NewDomainUrlDto> queryNewDomainListSimple(Long id);

    /**
     * 一键还原
     * @param appIds
     * @return
     */
    NewDomainReductionDto reductionDomain(List<Long> appIds) throws BizException;

    /**
     * 根据appId或标签id批量查询
     *
     * @param params
     * @return
     */
    public Page<AppLabelDetailDto> queryNewDomainLabelByAppOrLabelId(AppNewDomainQueryParams params);

    /**
     * 添加app
     *
     * @return
     */
    boolean insetAppLabelDetail(CreateAppNewDomainQueryParams params) throws BizException;

    /**
     * 添加/修改app审核通过
     *
     * @param appId
     * @return
     * @throws BizException
     */
    boolean insetOrEditAppLabelDetailPass(Long appId) throws BizException;

    /**
     * 添加app审核不通过
     * @param appId
     * @return
     * @throws BizException
     */
    boolean insetAppLabelDetailRefuse(Long appId);

    /**
     * 修改app审核不通过
     * @param params
     * @return
     * @throws BizException
     */
    boolean updateAppLabelDetailEntityRefuse(EditAppNewDomainQueryParams params);

    /**
     * 修改app
     *
     * @return
     */
    Integer updateAppLabelDetailEntity(EditAppNewDomainQueryParams params) throws BizException;

    /**
     * 根据appId查询app关联信息
     *
     * @param appId
     * @return
     */
    AppLabelSimpleDto queryNewDomainLabelSimpleByAppId(Long appId);

    /**
     * 批量修改app标签
     * @param oldId
     * @param newId
     * @return
     * @throws BizException
     */
    boolean updateAppLabelList(Long oldId, Long newId) throws BizException;

    /**
     * 批量修改app标签根据appid
     * @return
     * @throws BizException
     */
    boolean updateAppLabelListByAppIds(List<Long> appIds ,Long newLabelId) throws BizException;


    /**
     * 删除appid
     * @param appIds
     * @return
     * @throws BizException
     */
    boolean deleteApp(List<Long> appIds) throws BizException;

    /**
     * 批量根据添加域名
     * @param appIds
     * @param labelId
     * @return
     * @throws BizException
     */
    boolean addAppLabelListByAppIds(List<Long> appIds, Long labelId) throws BizException;
}
