package cn.com.duiba.developer.center.api.remoteservice.authority;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.authority.AuthorityEntityDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.DeveloperNewPowerListDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.ResourcesRelDto;
import cn.com.duiba.developer.center.api.domain.dto.authority.VerisonAppInfoDto;
import cn.com.duiba.developer.center.api.domain.param.authority.AuthorityTagInfoDto;
import cn.com.duiba.developer.center.api.domain.param.authority.ResourceTagDto;
import cn.com.duiba.developer.center.api.domain.param.authority.ResourcesDetailDto;
import cn.com.duiba.developer.center.api.domain.param.authority.VerisonAppListInfoDto;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionAppInfoParam;

import java.util.List;
@AdvancedFeignClient
public interface RemoteAuthorityService {


    /**
     *@Desc  获取版本权益标签 以及标签下包含哪些权限
     *@params  [id 版本id]
     */
    List<ResourceTagDto> versionAuthorityInfoList(Long id);


    /**
     *@Desc  查询指定版本下应用有效时间等信息
     *@params versionAppInfoParam
     */
    VerisonAppListInfoDto versionAppInfos(VersionAppInfoParam versionAppInfoParam);

    /**
     * 根据appId和套餐类型查找套餐列表
     * @param appId
     * @param attributeType
     * @return
     */
    List<VerisonAppListInfoDto.ListBean> listByAppIdAndAttributeType(Long appId, Integer attributeType);


    /**
     *@Desc  查询付费用户信息
     *@params versionAppInfoParam
     */
    VerisonAppInfoDto versionPayAppInfos(VersionAppInfoParam versionAppInfoParam);


    /**
     *@Desc  查询组件，补给站ID，营销活动与资源id 关系
     *@params
     */
    List<ResourcesRelDto> getResourcesRel();


    /**
     *@Desc 查询该appid 所拥有的权限id
     *@params appId
     */
    DeveloperNewPowerListDto getAppAuthorityTree(Long appId);


    /**
     *@Desc 新增权限
     *@params appId
     */
    Long save(AuthorityEntityDto authorityEntityDto);


    /**
     * 判断权限
     * @param authority
     * @param appId
     * @return
     */
    boolean checkAuthority(String authority,Long appId);

    List<VerisonAppListInfoDto.ListBean> getAllVersion(Long appId);

}
