package cn.com.duiba.developer.center.api.remoteservice.risk;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.risk.AccountExpendWarnDto;

/**
 * @author JunAngLiu
 * @Title: RemoteAccountExpendWarnService
 * @Description: 奖品发放预警配置
 * @date 2019/4/2811:27
 */
@AdvancedFeignClient
public interface RemoteAccountExpendWarnService {

    /**
     * 条件插入数据
     * @param record
     * @return
     */
    int insertSelective(AccountExpendWarnDto record);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    AccountExpendWarnDto selectByPrimaryKey(Long id);

    /**
     * 根据主键 条件更新
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(AccountExpendWarnDto record);

    /**
     * 根据条件 计算总数
     * @return
     */
    Integer countByConditions(Long appId,String appName);

    /**
     * 分页查询
     * @return
     */
    Page<AccountExpendWarnDto> queryPageByconditions(Long appId,String appName,Integer pageNo,Integer pageSize);

    /**
     * 根据appId 校验 当前是否存在
     * @param appId
     * @return
     */
    Boolean validByAppIdWithCache(Long appId);
}
