package cn.com.duiba.developer.center.api.domain.dto.monitor;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName WechatDomainMonitorDTO
 * @Description 微信域名防封监控DTO
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/7/16 11:44
 * @Version 1.0
 **/
public class WechatDomainMonitorDTO implements Serializable {
    private static final long serialVersionUID = -6795697695007453527L;

    private Long id;

    /**
     * 域名或具体地址链接
     */
    private String content;

    /**
     * 1：域名；2：具体落地页
     */
    private Integer type;

    /**
     * 开发者应用appId
     */
    private Long appId;

    /**
     * 截止时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date deadline;

    /**
     * 0：已下线；1：正常
     */
    private Integer status;

    /**
     * 告警人
     */
    private String alarmUser;

    /**
     * 告警人sso的用户id
     */
    private String alarmSsoId;

    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getDeadline() {
        return deadline;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAlarmUser() {
        return alarmUser;
    }

    public void setAlarmUser(String alarmUser) {
        this.alarmUser = alarmUser;
    }

    public String getAlarmSsoId() {
        return alarmSsoId;
    }

    public void setAlarmSsoId(String alarmSsoId) {
        this.alarmSsoId = alarmSsoId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
