package cn.com.duiba.developer.center.api.domain.enums.risk;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: RiskWhiteListTypeEnum
 * @Description:
 * @date 2019/6/1820:57
 */
public enum RiskWhiteListTypeEnum {

    APP(1,"应用白名单"),
    CONSUMER(2,"用户白名单"),
    IP(3,"IP白名单");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    RiskWhiteListTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RiskWhiteListTypeEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (RiskWhiteListTypeEnum rse:RiskWhiteListTypeEnum.values()) {
            if(Objects.equals(rse.getValue(),value)){
                return rse;
            }
        }
        return null;
    }

}
