package cn.com.duiba.developer.center.api.domain.paramquery.monitor;

import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryParam;

import java.util.Date;

/**
 * @ClassName WechatDomainMonitorParam
 * @Description 微信域名防封监控请求参数
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/7/16 11:39
 * @Version 1.0
 **/
public class WechatDomainMonitorParam extends PageQueryParam {
    private static final long serialVersionUID = -3784535466309502426L;

    private Long id;

    /**
     * 域名或具体地址链接
     */
    private String content;

    /**
     * 1：域名；2：具体落地页
     */
    private Integer type;

    /**
     * 开发者应用appId
     */
    private Long appId;

    /**
     * 截止时间
     */
    private Date deadline;

    /**
     * 0：已下线；1：正常
     */
    private Integer status;

    /**
     * 告警人
     */
    private String alarmUser;

    /**
     * 告警人sso的用户id
     */
    private String alarmSsoId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getDeadline() {
        return deadline;
    }

    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAlarmUser() {
        return alarmUser;
    }

    public void setAlarmUser(String alarmUser) {
        this.alarmUser = alarmUser;
    }

    public String getAlarmSsoId() {
        return alarmSsoId;
    }

    public void setAlarmSsoId(String alarmSsoId) {
        this.alarmSsoId = alarmSsoId;
    }
}
