package cn.com.duiba.developer.center.api.utils;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @version Created by zhenghuan on 2018/5/30 0030
 */
public class PasswordsUtil {

    private PasswordsUtil() {
        // empty
    }

    /**
     * 固定盐
     * 1.md5("www.dui88.com.cn")
     */
    private static final String SALT = "b1a2934c356633dd3e162cd8f3f33a33";

    /**
     * 假设用户账号 11@qq.com  密码明文 123
     * 加密过程:
     * 1. A=sha256("密码明文"+"固定盐")=sha256("123"+"b1a2934c356633dd3e162cd8f3f33a33")="1584a66b6f5815b4da83656bf67d1810e9093714cc4bd134c81478a0067cf46f"
     * 2. B=sha256("A"+"随机盐")=sha256("1584a66b6f5815b4da83656bf67d1810e9093714cc4bd134c81478a0067cf46f"+"11@qq.com")="fe4f06bf3787533900446914aa5f038ca9ac94c91dd501bb6d294b6c4a9dd6e6"
     * 3. B为所求
     * @param plaintext 密码明文
     * @param email     账户（这里做随机盐）
     * @return
     */
    public static String getHashPasswords(String plaintext, String email) {
        return SHA256Util.encrypt(SHA256Util.encrypt(plaintext + SALT) + email);
    }
}
