package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */
@Getter
@AllArgsConstructor
public enum PddTag {

    BAIDU_ADX_76(19, 1, 600, 300, "tuia_nat_600*300", "tuia_nat_600*300"),
    BAIDU_ADX_2447(19, 1, 640, 360, "tuia_nat_640*300", "mrk_union_tuia_auto_312"),
    BAIDU_ADX_125(19, 1, 360, 644, "tuia_splsh_360*644", "tuia_splsh_360*644"),
    BAIDU_ADX_2399(19, 1, 360, 800, "tuia_splsh_360*800", "tuia_splsh_360*800"),
    BAIDU_ADX_1280_720(19, 1, 1280, 720, "tuia_nat_600*300", "mrk_union_tuia_auto_287"),
    KUISHOU_175(36, 3, 1280, 720, "tuia_nat_600*300", "mrk_union_tuia_auto_175"),
    KUISHOU_174(36, 1, 720, 1280, "tuia_nat_600*300", "mrk_union_tuia_auto_174"),
    KUISHOU_173(36, 3, 720, 1280, "tuia_nat_600*300", "mrk_union_tuia_auto_173"),
    mongo_234(14, 1, 640, 120, "tuia_nat_600*300", "mrk_union_tuia_auto_234"),
    mongo_233(14, 1, 512, 288, "tuia_nat_600*300", "mrk_union_tuia_auto_233"),
    mongo_175(14, 3, 1280, 720, "tuia_nat_600*300", "mrk_union_tuia_auto_175"),
    mongo_174(14, 1, 720, 1280, "tuia_nat_600*300", "mrk_union_tuia_auto_174"),
    TANX_173(40, 3, 720, 1280, "tuia_nat_640*300", "mrk_union_tuia_auto_173"),
    TANX_289(40, 1, 600, 300, "tuia_nat_640*300", "mrk_union_tuia_auto_289"),
    TANX_175(40, 3, 1280, 720, "tuia_nat_640*300", "mrk_union_tuia_auto_175"),
    TANX_288(40, 1, 1280, 720, "tuia_nat_640*300", "mrk_union_tuia_auto_288"),

    ;


    /**
     * 媒体code
     */
    private Integer adxType;

    /**
     * 1图，3视频
     */
    private Integer type;

    /**
     * 百度流量的样式id
     */
    private Integer width;

    /**
     * 百度流量的样式id
     */
    private Integer height;
    /**
     * pdd的tagid（由我们提供广告位样式，他们给tagId）
     */
    private String tagId;
    /**
     * pdd的template（由我们提供广告位样式，他们给templateId）
     */
    private String templateId;

    public static PddTag getByStyleId(Integer adxType, Integer type, Integer h, Integer w) {
        // 百度的直接用长宽去匹配，因为不存在同一个尺寸多个广告位和模版的情况
        if (adxType == 19) {
            for (PddTag pddTag : PddTag.values()) {
                if (pddTag.getAdxType().equals(adxType) && pddTag.getHeight().equals(h) && pddTag.getWidth().equals(w)) {
                    return pddTag;
                }
            }
            // 目前只有快手，需要加上样式匹配
        } else {
            for (PddTag pddTag : PddTag.values()) {
                if (pddTag.getAdxType().equals(adxType) && type.equals(pddTag.getType()) && pddTag.getHeight().equals(h) && pddTag.getWidth().equals(w)) {
                    return pddTag;
                }
            }
        }

        return null;
    }
}
