package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
public class RgyunResponseConverter {

    public AdxCommonBidResponse respConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_4.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getId());
        List<CommonSeatBid> commonSeatBids = seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        commonSeatBid.setAdvertiserId("44910");
        //设置价格
        commonSeatBid.setPrice(StringUtils.isBlank(rtbResponse.getPrice()) ? 0 : Double.parseDouble(rtbResponse.getPrice()));
        commonSeatBid.setCommonCreative(creativeConvert(rtbResponse));
        //设置竞价胜出链接
        commonSeatBid.setWinCallbackUrl(rtbResponse.getNurl());
        //设置曝光链接
        commonSeatBid.setExposureCallbackUrl(getExposureUrl(rtbResponse.getPvList()));
        //设置点击链接
        commonSeatBid.setClickCallbackUrl(getClickUrl(rtbResponse.getClickList()));
        commonSeatBid.setCommonContext(commonContextConvert(rtbResponse));
        return commonSeatBidList;
    }

    private String getClickUrl(List<RgyunBiddingResponse.RTBResponse.Click> clickList) {
        if(CollectionUtils.isEmpty(clickList)){
            return null;
        }
        return clickList.get(0).getUrl();
    }

    private String getExposureUrl(List<RgyunBiddingResponse.RTBResponse.Pv> pvList) {
        if(CollectionUtils.isEmpty(pvList)){
            return null;
        }
        return pvList.get(0).getUrl();
    }

    private CommonContext commonContextConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        CommonContext commonContext = new CommonContext();
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        if(!RgyunBiddingResponse.RTBResponse.AdType.AT_Call.equals(adtype)){
            return commonContext;
        }
        commonContext.setDeepLinkUrl(rtbResponse.getDplurl());
        commonContext.setULinkUrl(rtbResponse.getJumpurl());
        return commonContext;
    }

    private CommonCreative creativeConvert(RgyunBiddingResponse.RTBResponse rtbResponse) {
        CommonCreative commonCreative = new CommonCreative();
        setLandPageUrlByAdType(rtbResponse, commonCreative);
        commonCreative.setBrandName("推啊");
        commonCreative.setCommonTitle(convertCommonTitle(rtbResponse.getTitle(), rtbResponse.getDesc()));
        commonCreative.setCommonDesc(commonDescConvert(rtbResponse.getDesc()));
        commonCreative.setCommonIcon(commonIconConvert(rtbResponse.getIconurl()));

        commonImageOrVideoConvert(rtbResponse, commonCreative);
        commonCreative.setAppName(rtbResponse.getApkname());
        commonCreative.setAppBundle(rtbResponse.getPackage());
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        //只有下载类型的广告才有
        if(RgyunBiddingResponse.RTBResponse.AdType.AT_AppDownload.equals(adtype)){
            commonCreative.setDownloadUrl(rtbResponse.getTarget());
            commonCreative.setPrivacyPolicyLink(rtbResponse.getPrivacylink());
            commonCreative.setPermissionLink(rtbResponse.getPermissionlink());
            commonCreative.setAppVersion(rtbResponse.getAppversion());
            commonCreative.setDeveloper(rtbResponse.getDeveloper());
        }
        Optional.of(rtbResponse.getIconurl()).ifPresent(o -> commonCreative.setIconUrl(o));
        return commonCreative;
    }

    private void setLandPageUrlByAdType(RgyunBiddingResponse.RTBResponse rtbResponse, CommonCreative commonCreative) {
        RgyunBiddingResponse.RTBResponse.AdType adtype = rtbResponse.getAdtype();
        if(adtype == null){
            return;
        }
        switch (adtype){
            //普通广告
            case AT_Normal:
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                break;
                //下载类广告
            case AT_AppDownload:
                break;
                //唤起类广告
            case AT_Call:
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                commonCreative.setDeepLinkUrl(rtbResponse.getDplurl());
                commonCreative.setULinkUrl(rtbResponse.getJumpurl());
                break;
                //互动广告
            case AT_Action:
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                break;
            default:
                commonCreative.setLandingPageUrl(rtbResponse.getTarget());
                break;
        }
    }

    private void commonImageOrVideoConvert(RgyunBiddingResponse.RTBResponse rtbResponse, CommonCreative commonCreative) {
        RgyunBiddingResponse.RTBResponse.MaterialType materialtype = rtbResponse.getMaterialtype();
        //图片类型广告
        if(RgyunBiddingResponse.RTBResponse.MaterialType.MT_Image.equals(materialtype)){
            commonCreative.setCommonImageList(convertCommImage(rtbResponse));
        }
        //视频类型广告
        if(RgyunBiddingResponse.RTBResponse.MaterialType.MT_Video.equals(materialtype)){
            commonCreative.setCommonVideoList(convertCommVideo(rtbResponse));
        }
    }

    private List<CommonVideo> convertCommVideo(RgyunBiddingResponse.RTBResponse rtbResponse) {
        ProtocolStringList adurlsList = rtbResponse.getAdurlsList();
        if(CollectionUtils.isEmpty(adurlsList)){
            return null;
        }
        List<CommonVideo> commonVideoList = Lists.newArrayList();
        adurlsList.forEach(url -> {
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(url);
            commonVideo.setResolutionY(rtbResponse.getHeight());
            commonVideo.setResolutionX(rtbResponse.getWidth());
            commonVideo.setCoverUrl(rtbResponse.getCoverimg());
            commonVideo.setDuration(new BigDecimal(rtbResponse.getDuration()));
            commonVideoList.add(commonVideo);
        });
        return commonVideoList;
    }

    private List<CommonImage> convertCommImage(RgyunBiddingResponse.RTBResponse rtbResponse) {
        ProtocolStringList adurlsList = rtbResponse.getAdurlsList();
        if(CollectionUtils.isEmpty(adurlsList)){
            return null;
        }
        List<CommonImage> commonImageList = Lists.newArrayList();
        adurlsList.forEach(url -> {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(url);
            commonImage.setHeight(rtbResponse.getHeight());
            commonImage.setWidth(rtbResponse.getWidth());
            commonImageList.add(commonImage);
        });
        return commonImageList;
    }

    private CommonIcon commonIconConvert(String iconurl) {
        if(StringUtils.isBlank(iconurl)){
            return null;
        }
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconurl);
        return commonIcon;
    }

    private CommonDesc commonDescConvert(String desc) {
        CommonDesc commonDesc = new CommonDesc();
        commonDesc.setDesc(desc);
        return commonDesc;
    }

    private CommonTitle convertCommonTitle(String title, String desc) {
        CommonTitle commonTitle = new CommonTitle();
        commonTitle.setTitle(title);
        commonTitle.setSubTitle(desc);
        return commonTitle;
    }
}
