package cn.com.duiba.tuia.dsp.engine.api.enums;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.RgyunDspInvoker;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * dspId 对应的竞价url
 *
 * @author lijian
 * @date 2020/04/13
 * @since JDK 1.8
 */
public enum DspEnum {


    /*DSP_1(1L, "http://172.16.47.169:17788/adxAdvert/comparePrice", "ab3128977c94a115f64d64cb5ba4379c", "58同城"),*/
//    DSP_2(2L, "京准通", null),
    DSP_3(3, "拼多多", PddDspInvoker.class),
    DSP_4(4, "软告", RgyunDspInvoker.class),
    ;

    private final Integer dspId;

    //dsp平台名称
    private final String desc;

    private final Class<? extends AbstractDspCaller> clazz;

    DspEnum(Integer dspId, String desc, Class<? extends AbstractDspCaller> clazz) {
        this.dspId = dspId;
        this.desc = desc;
        this.clazz = clazz;
    }

    public Integer getDspId() {
        return dspId;
    }

    public String getDesc() {
        return desc;
    }

    public Class<? extends AbstractDspCaller> getClazz() {
        return clazz;
    }

    private static Map<Integer, DspEnum> dspMap = Maps.newHashMap();

    static {
        for (DspEnum it : DspEnum.values()) {
            dspMap.put(it.getDspId(), it);
        }
    }

    public static DspEnum getByDspId(Integer dspId) {
        return dspMap.get(dspId);
    }

    public static Class<? extends AbstractDspCaller> getClazzByDspId(Integer dspId) {
        return dspMap.get(dspId).getClazz();
    }

}
