package cn.com.duiba.tuia.dsp.engine.api.config;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 阿波罗配置
 * 地址：https://console.dui88.com/apollo/#/service/applications/config/tuia-adx-web
 * 配置也可以这么玩，Apollo配置：cat.monitor.warn.req-null: 200
 * reqNull可以自动转化自req-null
 *
 * @author lizhiheng
 * @Component
 * @RefreshScope
 * @ConfigurationProperties(prefix = "cat.monitor.warn")
 * public class CatMonitorWarnThreshold {
 * private String reqNull=100;
 * private String consEmpty=50;
 */
@Component
@RefreshScope
@Data
@Slf4j
public class DspApolloConfig {


    @Value("#{'${dsp.media.log.whitelist:14}'.split(',')}")
    public Set<Integer> logWhiteList;

}
