package cn.com.duiba.tuia.dsp.engine.api.config;

import com.google.common.util.concurrent.RateLimiter;
import lombok.Data;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * DSP限流装置
 * 具体配置在RateLimiterProperties里
 *
 * @author lizhiheng
 */
@SuppressWarnings("UnstableApiUsage")
@Component
@Data
@RefreshScope
public class DspRateLimiter {

    private RateLimiter rateLimiter;

    @Resource
    private RateLimiterProperties rateLimiterProperties;

    @EventListener(value = RefreshScopeRefreshedEvent.class)
    public void change() {
        getClass();
    }

    @PostConstruct
    public void init() {
        rateLimiter = RateLimiter.create(rateLimiterProperties.getTokenPerSec(), 1, TimeUnit.MILLISECONDS);
    }


}
