package cn.com.duiba.tuia.dsp.engine.api.dsp.common.req;

import lombok.Data;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 通用竞价请求模型
 *
 * @author xierongli
 * @create 2019-11-18 17:08
 */
@Data
public class AdxCommonBidRequest {

    //竞价请求Id
    private String requestId;
    //竞价广告位集合
    private List<CommonImp> impList;
    //设备信息
    private CommonDevice device;
    //APP信息
    private CommonAppInfo appInfo;
    //用户信息
    private CommonUserInfo userInfo;
    // 竞价类型，1-一价计费;，2-二价计费，默认是2;
    private Integer at;
    //测试字段，是否涉及收费：0.
    private Integer test;
    //Adx平台类型
    private Integer adxType;
    //Adx平台编码
    private String adxCode;

//    //报价结果构造器
//    private Predicate<AdxBidPlusContext> resultBuildFunction;
//
    /** 0.测试组 1.对照组 **/
    private Integer isTestGroup;

    /**
     * 大媒体视频对象信息
     */
//    private VipVideoInfo videoInfo;

    /**
     * 直投定向过滤条件
     */
//    private FilterConditionBo filterCondition;

    /** 自定义的创意过滤器 */
//    private IdeaFilter ideaFilter;

    /**
     * 流量标识 :: 是否 Web 流量.
     */
    private boolean isWebTraffic;

    /**
     * 三方用户 Id
     * 注: 目前百度联盟 Web 流量使用.
     */
    private String thirdUserId;

    /**
     * 先荐adx，广告位类型
     * && 喜马拉雅style字段复用
     */
    private Integer slotType;

    /**
     * 先荐adx,原生广告位，由一系列 Asset 对象组成，response需要返回
     */
//    private List<BidReqResp.BidRequest.Imp.Native.Asset> assets;

    /**
     * 蜻蜓FM-v2，支持的创意交互类型：
     * 1 网页打开（默认）；
     * 2 网页打开+点击下载；
     * 3 网页打开+deeplink；
     * 4 网页打开+点击下载+deeplink
     */
    private List<Integer> acceptedInteractionType;

    /**
     *  蜻蜓fm-v2，只有 PMP 合作方使用，交易方式为 PDB 和 PD，详
     * 细字段见：DealId 对象
     */
    private String dealId;

    /**
     * 外部流量包ID
     */
    private String externalDataPackageId;

    /**
     * 协议
     */
    private Integer httpProtocol;

    /**
     * 行业id
     */
    private String category;

    /**
     * 媒体支持的计费类型（暂时只有百度联盟）
     * 0：cpm
     * 1：cpc
     */
    private Integer mediaChargeType;

    /**
     * 媒体支持的投放类型（暂时只有百度联盟）
     * 0：cpm
     * 1：cpc
     */
    private Integer mediaLaunchType;
}
