package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.*;
import lombok.Data;

import java.util.List;

/**
 * 相关字段含义见 http://cf.dui88.com/pages/viewpage.action?pageId=151652517
 * 媒体广告平台接入拼多多外投广告技术规范[0.0.10].pdf
 *
 * @author Wangpf
 * @date 2022/7/1 11:36 上午
 */
@Data
public class PddRequest {

    /**
     * 由拼多多分配媒体广告平台的唯一 id.
     */
    private String adx_id;
    /**
     * 每次请求的唯一标识
     */
    private String request_id;
    /**
     * 竞价类型;1 = first price; 2 = second price plus; 默认值 2
     */
    private int at;
    /**
     * 标识广告位曝光的 Imp 对象列表
     */
    private List<Imp> imp;
    /**
     * site 流量方对象，只针对 website 流量时存在
     */
    private Site site;
    /**
     * app 流量方对象，只针对 app 流量时存在
     */
    private App app;
    /**
     * device 对象，描述用户的设备信息
     */
    private Device device;
    /**
     * user 对象，该设备的用户信息，投放受众
     */
    private User user;
    /**
     * 扩展信息.json 字符串，媒体广告平台和拼多多约定
     */
    private String ext;
}
