package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author yuquanfeng
 * @Date 2022/10/9
 * @Description
 * @Param
 * @return
 **/
public class CarrierConverter {
    //移动
    public static final String MOVE = "1";
    //联通
    public static final String UNICOM = "2";
    //电信
    public static final String TELECOM = "3";

    public static RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType getCarrierType(String carrier) {
        if(StringUtils.isBlank(carrier)){
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType.CT_UNKNOWN;
        }
        switch (carrier){
            case MOVE:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType.CT_Mobile;
            case UNICOM:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType.CT_Unicom;
            case TELECOM:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType.CT_Telecom;
            default:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.CarrierType.CT_UNKNOWN;
        }
    }
}
