/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.RgyunProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.Key;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class RgyunDspInvoker
extends AbstractDspCaller<RgyunBiddingResponse.RTBResponse, RgyunBiddingRequest.RTBRequest> {
    private static final Logger log = LoggerFactory.getLogger(RgyunDspInvoker.class);
    private static final String TOKEN = "d6797b0f95f8ead2";
    @Resource
    private RgyunRequestConverter rgyunRequestConverter;
    @Resource
    private RgyunResponseConverter rgyunResponseConverter;
    @Resource
    private RgyunProperties rgyunProperties;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected RgyunBiddingResponse.RTBResponse invokeDsp(RgyunBiddingRequest.RTBRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u8f6f\u544aDSP\u8c03\u7528");
        try {
            return (RgyunBiddingResponse.RTBResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.rgyunProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"rgyun");
        }
        catch (ResourceAccessException e) {
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            SamplerLog.warn((String)"\u8f6f\u544a\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            return null;
        }
    }

    private RgyunBiddingResponse.RTBResponse doHttpInvoke(String url, RgyunBiddingRequest.RTBRequest rtbRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf");
        HttpEntity requestEntity = new HttpEntity((Object)rtbRequest.toByteArray(), (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        RgyunBiddingResponse.RTBResponse body = RgyunBiddingResponse.RTBResponse.parseFrom(resource.getInputStream());
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                Cat.logMetricForCount((String)"\u8f6f\u544aDSP\u8fd4\u56de");
                return body;
            }
            SamplerLog.info((String)"\u8f6f\u544aDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
            Cat.logMetricForCount((String)"\u8f6f\u544aDSP\u8fd4\u56de2xx");
            return null;
        }
        if (statusCode.is5xxServerError()) {
            Cat.logMetricForCount((String)"\u8f6f\u544aDSP\u8fd4\u56de5xx");
            SamplerLog.info((String)"\u8f6f\u544aDSP\u8fd4\u56de5xx,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
            return null;
        }
        Cat.logMetricForCount((String)"\u8f6f\u544aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801");
        SamplerLog.info((String)"\u8f6f\u544aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] raw = TOKEN.getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            IvParameterSpec iv = new IvParameterSpec(raw);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes("utf-8"));
            byte[] encodeBase64 = Base64.encodeBase64URLSafe((byte[])encrypted);
            return new String(encodeBase64, "utf-8");
        }
        catch (Exception e) {
            log.warn("RgyunDspInvoker \u4ef7\u683c\u89e3\u5bc6\u5931\u8d25");
            return null;
        }
    }

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        return super.doBid(commonBidRequest, dspInfo);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_4.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_4;
    }

    @Override
    public RgyunBiddingRequest.RTBRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.rgyunRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(RgyunBiddingResponse.RTBResponse rtbResponse) throws DspException {
        try {
            return this.rgyunResponseConverter.respConvert(rtbResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

