/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DeviceTypeConverter {
    private static final Pattern PATTERN_IPHONE = Pattern.compile("\\((iPhone);(.+?)\\)");
    private static final Pattern PATTERN_IPAD = Pattern.compile("(iPad).*OS\\s([\\d_]+)");
    private static final Pattern PATTERN_ANDROID = Pattern.compile(";\\s?(((\\d|[a-z]|[A-Z]|-|_)*?\\s)*?)(Build)?/");
    private static final Pattern HARMONYOS = Pattern.compile("HarmonyOS;\\s?(\\S*)");
    private static final Pattern HARMONYOS2 = Pattern.compile(";\\s?(\\S*); HMSCore");

    public static RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType getDeviceType(String ua) {
        if (StringUtils.isBlank((CharSequence)ua)) {
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_Android;
        }
        if (PATTERN_IPHONE.matcher(ua).find()) {
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_Iphone;
        }
        if (PATTERN_IPAD.matcher(ua).find()) {
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_Ipad;
        }
        if (DeviceTypeConverter.isAndroid(ua)) {
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_Android;
        }
        if (ua.contains("Windows") || ua.contains("Mac")) {
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_PC;
        }
        return RgyunBiddingRequest.RTBRequest.DeviceInfo.DeviceType.DT_Android;
    }

    private static boolean isAndroid(String ua) {
        if (PATTERN_ANDROID.matcher(ua).find() || HARMONYOS.matcher(ua).find() || HARMONYOS2.matcher(ua).find()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

