/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.util;

import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UAUtils {
    private static final Logger logger = LoggerFactory.getLogger(UAUtils.class);
    public static final String MODEL_IPHONE = "iPhone";
    private static final Pattern PATTERN_IPHONE = Pattern.compile("\\((iPhone);(.+?)\\)");
    private static final Pattern PATTERN_ANDROID = Pattern.compile(";\\s?(((\\d|[a-z]|[A-Z]|-|_)*?\\s)*?)(Build)?/");
    private static final Pattern HARMONYOS = Pattern.compile("HarmonyOS;\\s?(\\S*)");
    private static final Pattern HARMONYOS2 = Pattern.compile(";\\s?(\\S*); HMSCore");

    private UAUtils() {
    }

    public static UAData parseUA(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return new UAData();
        }
        UAData data = new UAData();
        data.setUa(userAgent);
        try {
            Matcher iphoneMatcher = PATTERN_IPHONE.matcher(userAgent);
            if (iphoneMatcher.find()) {
                data.setOsType("iOS");
                data.setModel(MODEL_IPHONE);
                data.setVendor("apple");
                return data;
            }
            Matcher androidMatcher = PATTERN_ANDROID.matcher(userAgent);
            if (androidMatcher.find() && androidMatcher.groupCount() > 0) {
                String model = androidMatcher.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
            Matcher HarmonyMatcher = HARMONYOS.matcher(userAgent);
            if (HarmonyMatcher.find()) {
                String model = HarmonyMatcher.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
            Matcher HarmonyMatcher1 = HARMONYOS2.matcher(userAgent);
            if (HarmonyMatcher1.find()) {
                String model = HarmonyMatcher1.group(1).trim();
                data.setOsType("Android");
                data.setModel(model);
                data.setVendor(null);
                return data;
            }
        }
        catch (Exception e) {
            System.out.println("\u5f02\u5e38ua\u300b\u300b\u300b\u300b" + userAgent);
            logger.warn("Parse ua failed.", (Throwable)e);
        }
        return data;
    }
}

