package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.config.DspApolloConfig;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 调用第三方dsp的caller
 * 子类实现调用第三方的invokeDsp方法和对应的converter即可
 *
 * @param <DspRsp>
 * @param <DspReq>
 * @author lizhiheng
 */
@Component
@Slf4j
public abstract class AbstractDspCaller<DspRsp, DspReq> implements DspAdapter<DspRsp> {


    public static final String JSTR = "{\"commonSeatBidList\":[{\"advertiserId\":\"pinduoduo\",\"clickCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/c/mrk_union?acc=100001&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&source=0&lx=1&creative_id=101377678012&super_channel=mrk_union_tuia&cate3_id=5836&ut=3&audience=0&idfa=8f802bd2c3cc50a2473fb23de4b9027e&goods_id=278945178607&cate_id=5836&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&pcvr=6.0E-5&y4=9055&pkg_id=5378973&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&os=ios&launch_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&lxt=98&mat_c=6&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&ltv=113.34192657470703&st16=0&ct=0&app_name=&st1=34&st12=1&st5=6.0E-5&st8=0&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1&cate2_id=5835&hg_env=qcloud&did=8f802bd2c3cc50a2473fb23de4b9027e\",\"commonContext\":{\"deepLinkUrl\":\"pddopen://pinduoduo?h5Url=mtr_portals.html%3F_p_acc%3D100001%26_p_source%3D0%26_p_cate1_id%3D5834%26_p_ads_id%3D-1%26_p_jump_id%3D1770%26_p_vids%3D8513%2C9345%2C9282%2C8774%2C400000%2C8331%2C9292%2C8665%2C6000002%2C8668%2C9055%2C8546%2C8933%2C8998%2C7079%2C8871%2C6058%2C9258%2C8751%2C8818%2C8178%2C9266%2C8051%2C9268%2C8893%2C9278%26_p_ads_sub_channel%3Dmrk_union_tuia%26y2%3D9268%26sn%3Dnt_ce740e10%26_p_ads_channel%3Dmrk_union%26y4%3D9055%26_p_ads_csite%3Dtuia_aff_splsh%26m_id%3D81709f%26y9%3D8331%26_p_ads_type%3Dlaxin%26_p_ads_set%3D10004290%26_p_launch_id%3De9154a0aafc70d636002000060c9e00080bccf1d_0%26_p_super_channel%3Dmrk_union_tuia%26_p_bucket_dsp%3D45%26goods_id%3D278945178607%26_p_launch_type%3Ddsp%26_p_mat_pkg_id%3D5378973%26_p_creative_id%3D101377678012%26st16%3D0%26_p_pdd_bid_id%3De9154a0aafc70d636002000060c9e00080bccf1d_0%26st12%3D1%26_p_display_id%3D1325%26st8%3D0%26y20%3D400000%26_oc_ads_channel%3Dmrk_union%26st11%3D0%26_p_mt_id%3D101377678012%26_p_soid%3De9154a0aafc70d636002000060c9e00080bccf1d%26_p_plgsn%3D1b0414324f958f6191c3390e2022755f%26_p_is_reten%3D0%26_p_vers%3DA2c-L-V-Finner-S6a&direct_back=true\"},\"commonCreative\":{\"appBundle\":\"1044283059\",\"appName\":\"拼多多\",\"appVersion\":\"6.25.0\",\"commonDesc\":{},\"commonImageList\":[{\"height\":1280,\"url\":\"http://images.pinduoduo.com/marketing_api/2022-08-20/8d8509d3-1e45-46f4-aa46-e8c95c363767.png?imageMogr2/thumbnail/360x644!\",\"width\":720}],\"commonTitle\":{\"title\":\"苹果手机降价啦！\"},\"developer\":\"上海寻梦信息技术有限公司\",\"downloadUrl\":\"https://api.pinduoduo.com/api/app/channel/pinduoduo_main_mrk_union_max\",\"landingPageUrl\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&acc=100001&mt_id=101377678012&ads_type=laxin&vers=A2c-L-V-Finner-S6a&_dr_m_id=81709f&source=0&lx=1&creative_id=101377678012&super_channel=mrk_union_tuia&page_uid=b5af197d12ad4d18b4b467684f90f17b&ut=3&audience=0&abs_id=152848&goods_id=278945178607&_da_is_reten=0&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&ads_channel=mrk_union&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&y4=9055&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&plsn=4cdcaffa7fe6deb33f6ad2f99a706b0b&os=ios&src=mrk_union&lxt=98&mat_c=6&st0=-1&ltv=113.34192657470703&st2=gzyDSg%2FQeq0W81JhVb7yu4ohESI4ltUIpvFwEJPUq2ofXXdaWEGdUQ%3D%3D&st16=0&app_name=&st1=34&mat_pkg_id=5378973&st12=1&st13=97mikHGlbUEfXXdaWEGdUQ%3D%3D&st8=0&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1\",\"permissionLink\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&plsn=c62e1fb641c2b1accab9f99123f47d08&ads_channel=mrk_union&abs_id=140902&page_uid=86ec47c2c03a4b3499d62161c41ff01b\",\"privacyPolicyLink\":\"https://mobile.yangkeduo.com/private_policy.html\"},\"exposureCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/i/mrk_union?acc=100001&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&source=0&lx=1&creative_id=101377678012&price=%%PRICE%%&super_channel=mrk_union_tuia&cate3_id=5836&ut=3&audience=0&goods_id=278945178607&cate_id=5836&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&y4=9055&pkg_id=5378973&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&os=ios&lxt=98&mat_c=6&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&st2=8f802bd2c3cc50a2473fb23de4b9027e&st16=0&ct=0&app_name=&st1=34&st4=0.05025&st6=155&st12=1&st5=6.0E-5&st8=0&st10=1.03401&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1&cate2_id=5835&hg_env=qcloud&did=8f802bd2c3cc50a2473fb23de4b9027e\",\"price\":155.0,\"winCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/w/mrk_union?acc=100001&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&ad_tag=1%3A5834%3A2&source=0&lx=1&creative_id=101377678012&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&price=%%PRICE%%&super_channel=mrk_union_tuia&y2=9268&y4=9055&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&ut=3&y9=8331&audience=0&os=ios&goods_id=278945178607&lxt=98&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&st16=0&ads_set=10004290&app_name=&st1=34&st12=1&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&st8=0&y20=400000&st7=-1&st11=0&did=8f802bd2c3cc50a2473fb23de4b9027e&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0\"}],\"dspId\":3,\"requestId\":\"9791855853c04fbf\"}";

    @Resource
    DspApolloConfig dspApolloConfig;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        Integer adxCode = commonBidRequest.getAdxType();
        try {

//            this.catLogAndSampleLog(commonBidRequest, "adxCommonBidRequest", commonBidRequest);

            DspReq dspReq = this.convertReq(commonBidRequest, dspInfo);
            this.catLogAndSampleLog(commonBidRequest, "dspReq", dspReq);

            DspRsp dspRsp = this.invokeDsp(dspReq);

            AdxCommonBidResponse adxCommonBidResponse = this.convertResp(dspRsp);
            if (adxCommonBidResponse != null) {
                this.catLogAndSampleLog(commonBidRequest, "dspRsp", JSON.toJSONString(dspRsp));
            }

            return adxCommonBidResponse;
        } catch (Exception e) {
            SamplerLog.warn("DSP请求失败", e);
            Cat.logMetricForCount(getDsp().getDesc() + "_竞价失败");
            return null;
        }
    }

    public void catLogAndSampleLog(AdxCommonBidRequest request, String logBody, Object object) {
        String adxCode = request.getAdxCode();
        Integer adxType = request.getAdxType();
        // cat监控
        Cat.logMetricForCount(adxCode + "_" + logBody);
        // 采样日志
        SamplerLog.info(logBody + " adxCode is {} dsp is {} body is {}", adxCode, getDsp().getDesc(), object);
    }

    /**
     * 调用第三方DSP
     *
     * @param dspReq
     * @return
     */
    protected abstract DspRsp invokeDsp(DspReq dspReq);


    /**
     * 价格解密
     *
     * @param price
     * @return
     */
    public abstract String priceEncryption(BigDecimal price);

    /**
     * 获取dspid
     *
     * @return
     */
    protected abstract Integer getDspId();

    /**
     * 获取DSP枚举值
     *
     * @return
     */
    protected abstract DspEnum getDsp();

    /**
     * 宏替换含有价格的url
     *
     * @param price
     * @param url
     * @return
     */
    protected abstract String replaceUrl(String price, String url);

    /**
     * 竞价胜出回调广告主
     *
     * @param url 回调链接
     */
    public abstract void doWinCallBack(String url);

    /**
     * 点击回调广告主
     *
     * @param url 回调链接
     */
    public abstract void doClickCallBack(String url);

    /**
     * 曝光回调广告主
     *
     * @param url 回调链接
     */
    public abstract void doExposureCallBack(String url);
}

