package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.rsp.Adm;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.rsp.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.rsp.Seatbid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lizhiheng
 */
@Component
public class PddRespConverter {
    public AdxCommonBidResponse respConvert(PddResponse pddResponse) {
        if (Objects.isNull(pddResponse) || Objects.isNull(pddResponse.getSeatbid())) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_3.getDspId());
        adxCommonBidResponse.setRequestId(pddResponse.getRequest_id());
        List<CommonSeatBid> commonSeatBids = pddResponse.getSeatbid().stream().map(this::seatConvert).collect(Collectors.toList());
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private CommonSeatBid seatConvert(Seatbid seatbid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBid.setAdvertiserId("44079");
        Bid bid = seatbid.getBid().get(0);
        commonSeatBid.setPrice(Double.parseDouble(String.valueOf(bid.getPrice())));
        commonSeatBid.setCommonCreative(this.creativeConvert(bid));
        List<String> winCallbackUrls = new ArrayList<>();
        winCallbackUrls.add(bid.getNurl());
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        List<String> exposureUrls = new ArrayList<>(bid.getIurl().size());
        exposureUrls.addAll(bid.getIurl());
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        List<String> clickUrls = new ArrayList<>(bid.getCurl().size());
        clickUrls.addAll(bid.getCurl());
        commonSeatBid.setClickCallbackUrls(clickUrls);
        commonSeatBid.setCommonContext(this.commonContextConvert(seatbid.getBid()));
//        commonSeatBid.setCommonContext();
//        commonSeatBid.setAdSlotType();
        return commonSeatBid;
    }

    private CommonContext commonContextConvert(List<Bid> bids) {
        CommonContext commonContext = new CommonContext();
        if (Objects.isNull(bids) || bids.isEmpty() || Objects.isNull(bids.get(0))) {
            return commonContext;
        }
        commonContext.setDeepLinkUrl(bids.get(0).getDeeplink_url());
        return commonContext;
    }

    private CommonCreative creativeConvert(Bid bid) {
        CommonCreative commonCreative = new CommonCreative();
        Adm adm = bid.getAdm();
//        commonCreative.setCreativeId();
//        commonCreative.setMaterialId();
//        commonCreative.setCreativeTypeId();
//        commonCreative.setCreativeStyleId();
        commonCreative.setLandingPageUrl(bid.getClick_url());
        commonCreative.setBrandName(adm.getBrand());
        commonCreative.setCommonTitle(this.commonTitleConvert(adm));
        commonCreative.setCommonDesc(this.commonDescConvert(adm));
//        commonCreative.setCommonIcon();

        commonCreative.setCommonImageList(this.commonImageConvert(adm));
        commonCreative.setCommonVideoList(this.commonVideoConvert(adm));
        commonCreative.setAppName(bid.getApp_name());
        commonCreative.setAppBundle(bid.getApp_bundle());
        Optional.of(adm).ifPresent(o -> commonCreative.setIconUrl(o.getIcon_url()));

        String ext = bid.getExt();
        if (Objects.nonNull(ext)) {
            JSONObject jsonExt = JSONObject.parseObject(ext);
            commonCreative.setPrivacyPolicyLink(jsonExt.getString("privacy_policy_link"));
            commonCreative.setPermissionLink(jsonExt.getString("permission_link"));
            commonCreative.setAppVersion(jsonExt.getString("app_version"));
            commonCreative.setDownloadUrl(jsonExt.getString("download_url"));
            commonCreative.setDeveloper(jsonExt.getString("developer"));
        }
//        commonCreative.setCommonCreativeExt();
        return commonCreative;
    }

    private CommonDesc commonDescConvert(Adm adm) {
        CommonDesc commonDesc = new CommonDesc();
        commonDesc.setDesc(adm.getDesc());
        return commonDesc;
    }

    private List<CommonVideo> commonVideoConvert(Adm adm) {
        if (StringUtils.isEmpty(adm.getVideo_url())) {
            return null;
        }
        CommonVideo commonVideo = new CommonVideo();
//        commonVideo.setId();
        commonVideo.setVideoUrl(adm.getVideo_url());
//        commonVideo.setSize();
//        commonVideo.setUnit();
        commonVideo.setDuration(BigDecimal.valueOf(adm.getDuration()));
        commonVideo.setResolutionX(adm.getWidth());
        commonVideo.setResolutionY(adm.getHeight());
        commonVideo.setCoverUrl(adm.getVideo_background_url());
//        commonVideo.setCoverWidth();
//        commonVideo.setCoverHeight();
        return Collections.singletonList(commonVideo);
    }

    private List<CommonImage> commonImageConvert(Adm adm) {
        if (adm.getImage_url().isEmpty()) {
            return null;
        }
        CommonImage commonImage = new CommonImage();
//        commonImage.setId();
        commonImage.setUrl(adm.getImage_url().get(0));
        commonImage.setHeight(adm.getHeight());
        commonImage.setWidth(adm.getWidth());
//        commonImage.setSize();
//        commonImage.setUnit();
//        commonImage.setFormat();
        return Collections.singletonList(commonImage);
    }

    private CommonTitle commonTitleConvert(Adm adm) {
        CommonTitle commonTitle = new CommonTitle();
        commonTitle.setTitle(adm.getTitle());
        commonTitle.setSubTitle(adm.getDesc());
        return commonTitle;
    }
}
