package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */
@Getter
@AllArgsConstructor
public enum PddTag {

    BAIDU_ADX_76(600, 300, "tuia_nat_600*300", "tuia_nat_600*300"),
    BAIDU_ADX_2447(640, 360, "tuia_nat_640*360", "tuia_nat_640*360"),
    BAIDU_ADX_125(360, 644, "tuia_splsh_360*644", "tuia_splsh_360*644"),
    BAIDU_ADX_2399(360, 800, "tuia_splsh_360*800", "tuia_splsh_360*800"),
    ;


    /**
     * 百度流量的样式id
     */
    private Integer width;

    /**
     * 百度流量的样式id
     */
    private Integer height;
    /**
     * pdd的tagid（由我们提供广告位样式，他们给tagId）
     */
    private String tagId;
    /**
     * pdd的template（由我们提供广告位样式，他们给templateId）
     */
    private String templateId;

    public static PddTag getByStyleId(Integer h, Integer w) {
        for (PddTag pddTag : PddTag.values()) {
            if (pddTag.getHeight().equals(h) && pddTag.getWidth().equals(w)) {
                return pddTag;
            }
        }
        return null;
    }
}
