package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddTag;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.*;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lizhiheng
 */
@Component
public class PddReqConverter {
    @Resource
    PddProperties dspPddProperties;

    public PddRequest reqConvert(AdxCommonBidRequest commonReq) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();

        // 广告位转换
        List<Imp> imps = impList.stream()
                .map(this::impConvert)
                .collect(Collectors.toList());
        pddRequest.setImp(imps);

        pddRequest.setSite(new Site());
        pddRequest.setApp(new App());
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
//        pddRequest.setExt();
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
//        user.setTag_id();
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
//        user.setConsume_level();
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
//        device.setIpv6();
        device.setDevicetype(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setOs(commonDevice.getOs());
//        device.setOsv();
//        device.setH();
//        device.setW();
        // 这个不设置，因为每个媒体的枚举值都不一样，而且非必须
//        device.setConnectiontype(commonDevice.getConnectionType());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
//        device.setAndroidid();
//        device.setAndroidid_md5();
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
//        device.setCaid();
//        device.setPaid();
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
//        device.setExt();
        return device;

    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(lat.floatValue()));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(leo.floatValue()));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        app.setId(appInfo.getId());
        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
//        app.setApp_scheme("");
        return app;
    }

    public Imp impConvert(CommonImp commonImp) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return imp;
        }
        CommonSizeInfo commonSizeInfo = null;
        if (commonImp.getFilteringSize() != null && !commonImp.getFilteringSize().isEmpty()) {
            commonSizeInfo = commonImp.getFilteringSize().get(0);
        }
        imp.setId(commonImp.getId());

        if (Objects.nonNull(commonSizeInfo)) {
            // 不打算用盘古，就先这样吧
//            if (SpringEnvironmentUtils.isTestEnv()) {
            PddTag pddTag = PddTag.getByStyleId(commonSizeInfo.getHeight(), commonSizeInfo.getWidth());
            if (Objects.nonNull(pddTag)) {
                imp.setTagid(pddTag.getTagId());
                imp.setTemplates(Collections.singletonList(new Template(pddTag.getTemplateId())));
            }
//            } else {
//            PddTagOnline pddTagOnline = PddTagOnline.getByStyleId(commonSizeInfo.getHeight(), commonSizeInfo.getWidth());
//            if (Objects.nonNull(pddTagOnline)) {
//                imp.setTagid(pddTagOnline.getTagId());
//                imp.setTemplates(Collections.singletonList(new Template(pddTagOnline.getTemplateId())));
////                }
//            }
        }
        // FIXME: 2022/7/11 暂时写死记得删除
//        imp.setTagid("tuia_nat_600*300");
//        imp.setTemplates(Collections.singletonList(new Template("tuia_nat_600*300")));
        imp.setBidfloor((int) Math.round(commonImp.getFloorPrice()));

        // 2.应用下载类,目前对接拼多多，只有下载类广告
        imp.setContent_type(Arrays.asList(1, 2));
//        imp.setKeyword();
//        imp.setDealid();
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
//        imp.setH();
//        imp.setW();
//        imp.setBcat();
//        imp.setWcat();
        //这里不需要传ext，因为是要和pdd约定的，众多媒体，约不过来
//        imp.setExt(commonImp.getExt());
        return imp;
    }

    public static void main(String[] args) {
        String commonBidReq = "{\"adxCode\":\"baiduAlliance\",\"adxType\":19,\"appInfo\":{\"bundle\":\"com.shyz.toutiao\",\"id\":\"11223311\",\"name\":\"11223311\",\"version\":\"\"},\"category\":\"2402\",\"device\":{\"carrier\":\"0\",\"connectionType\":\"4\",\"deviceType\":0,\"dpIdMd5\":\"fb9a624166d88cdd3f417c${cnt}f1c106\",\"geo\":{\"city\":\"\",\"country\":\"中国\",\"region\":\"\",\"type\":0},\"hasDevice\":false,\"ip\":\"10.58.31.1\",\"make\":\"\",\"model\":\"\",\"os\":\"ANDROID\",\"ua\":\"Mozilla/5.0 (Linux; U; Androi d 2.3.6; zh-cn; GT-S5660 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1 MicroMessenger/4.5.255\"},\"externalDataPackageId\":\"100193\",\"filterCondition\":{\"adxFilterApplication\":\"11223311\",\"adxFilterPlatform\":\"03\"},\"impList\":[{\"adSlotType\":13,\"bidType\":1,\"externalAdBlockId\":\"8523\",\"filtering\":true,\"filteringSize\":[{\"height\":640,\"width\":960}],\"filteringTagIdSet\":[\"10011001110\",\"20022002220\",\"30033003330\",\"40044004440\",\"50055005550\",\"60066006660\",\"10001010001010100\",\"20002020002020200\",\"30003030003030300\"],\"floorPrice\":1.0,\"formatTypes\":[{\"height\":640,\"width\":960}],\"linkAgreement\":true,\"materialSpecInfo\":{\"height\":640,\"width\":960},\"openDeepLink\":false,\"tagId\":\"70077007770\",\"tagIndex\":1}],\"mediaChargeType\":2,\"mediaLaunchType\":1,\"requestId\":\"5b6da56c52168b02\",\"videoInfo\":{\"baiduVideo\":{\"adSlotType\":13,\"city\":\"\",\"contentLength\":0,\"district\":\"\",\"pageType\":0,\"province\":\"\",\"street\":\"\",\"title\":\"\",\"url\":\"https:// miniimg.eastday.com/detail_new/n200613083332625.html\",\"userTagIdList\":[100193]}},\"webTraffic\":false}";
        AdxCommonBidRequest adxCommonBidRequest = JSONObject.parseObject(commonBidReq, AdxCommonBidRequest.class);
    }
}
