package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Request;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Response;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.AdMobileRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.AdMobileResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.DSP_HTTP_INVOKE_FAILED;
import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.DSP_INVOKE_FAILED;

/**
 * @author wangwei
 */
@Slf4j
@Component
public class AdMobileDspInvoker extends AbstractDspCaller<Response, Request> {
    @Autowired
    private AdMobileProperties adMobileProperties;
    @Autowired
    private AdMobileRequestConvert adMobileRequestConvert;
    @Autowired
    private AdMobileResponseConvert adMobileResponseConvert;
    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;


    @Override
    protected Response invokeDsp(Request request) {
        if (request == null) {
            return null;
        }
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(adMobileProperties.getUrl(), request), "invokeDSP", "AdMobile");
        } catch (Throwable t) {
            Cat.logMetricForCount("AdMobile_竞价失败");
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("AdMobile调用异常", t);
            }
        }
        return null;
    }

    private Response doHttpInvoke(String url, Request request) {
        Cat.logMetricForCount("ADMobile_DSP调用");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<Request> requestEntity = new HttpEntity<>(request, headers);
        ResponseEntity<Response> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Response.class);
        } catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn("ADMobile 调用异常", e);
            }
            return null;
        }

        HttpHeaders respHeaders = resEntity.getHeaders();
        String traceId = respHeaders.getFirst("x-tm-traceid");

        Response body = resEntity.getBody();
        if (body != null && body.getCode() == 200) {
            body.setTraceId(traceId);
            Cat.logMetricForCount("ADMobile_DSP返回");
            if (SamplerLog.infoFlag()) {
                SamplerLog.info("");
            }
            return body;
        } else {
            if (SamplerLog.infoFlag()) {
                SamplerLog.info("ADMobile DSP无内容返回,ADMobile Resp body {}", JSONObject.toJSONString(request), JSONObject.toJSONString(body));
            }
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("0276af914fee82a4".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            String s = Base64.getEncoder().encodeToString(bytes);
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        } catch (Exception e) {
            log.warn("AdMobile加密失败 ", e);
        }
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_9.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_9;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__TM_BID_PRICE__") && price != null) {
            url = url.replaceAll("__TM_BID_PRICE__", price);
        }
        return url;
    }

    @Override
    public Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return adMobileRequestConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(Response response) throws DspException {
        return adMobileResponseConvert.convert(response);
    }
}
