package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/10/9
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum RgyunTag {
    /********精准*********/
    TUIA_1(44, 1, 720, 1280, "1005143", 7, "1"),

    /********tanx*********/
    TANX_27_1(40, 1, 600, 300, "1005144", 27, "27-1"),
    TANX_27_2(40, 1, 1280, 720, "1005144", 27, "27-2"),
    TANX_4(40, 3, 720, 1280, "1005143", 7, "4"),
    TANX_27_3(40, 3, 1280, 720, "1005144", 27, "27-3"),

    /********百度*********/
    BAIDU_ADX_2(19, 1, 360, 800, "1005143", 7, "2"),
    BAIDU_ADX_3(19, 1, 360, 644, "1005143", 7, "3"),

    /********芒果*********/
    MONGO_234_1(14, 1, 720, 1280, "1005143", 7, "1"),
    MONGO_234_27_3(14, 3, 1280, 720, "1005144", 27, "27-3"),
    ;


    /**
     * 媒体code
     */
    private Integer adxType;

    /**
     * 1图，3视频
     */
    private Integer type;

    /**
     * 百度流量的样式id
     */
    private Integer width;

    /**
     * 百度流量的样式id
     */
    private Integer height;
    /**
     * pdd的tagid（由我们提供广告位样式，他们给tagId）
     */
    private String tagId;
    /**
     * 广告位置
     */
    private Integer posId;
    /**
     * pdd的template（由我们提供广告位样式，他们给templateId）
     */
    private String templateId;

    RgyunTag(Integer adxType, Integer type, Integer width, Integer height, String tagId, Integer posId, String templateId){
        this.adxType = adxType;
        this.type = type;
        this.width = width;
        this.height = height;
        this.tagId = tagId;
        this.posId = posId;
        this.templateId = templateId;
    }

    public static RgyunTag getByStyleId(Integer adxType, Integer type, Integer h, Integer w) {
        // 百度的直接用长宽去匹配，因为不存在同一个尺寸多个广告位和模版的情况
        if (adxType == 19 || adxType == 44 || adxType == 14) {
            for (RgyunTag rgyunTag : RgyunTag.values()) {
                if (rgyunTag.getAdxType().equals(adxType) && rgyunTag.getHeight().equals(h) && rgyunTag.getWidth().equals(w)) {
                    return rgyunTag;
                }
            }
        } else {
            for (RgyunTag rgyunTag : RgyunTag.values()) {
                if (rgyunTag.getAdxType().equals(adxType) && type.equals(rgyunTag.getType()) && rgyunTag.getHeight().equals(h) && rgyunTag.getWidth().equals(w)) {
                    return rgyunTag;
                }
            }
        }
        return null;
    }
}
