/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.AdMobileProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Request;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Response;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.AdMobileRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.AdMobileResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class AdMobileDspInvoker
extends AbstractDspCaller<Response, Request> {
    private static final Logger log = LoggerFactory.getLogger(AdMobileDspInvoker.class);
    @Autowired
    private AdMobileProperties adMobileProperties;
    @Autowired
    private AdMobileRequestConvert adMobileRequestConvert;
    @Autowired
    private AdMobileResponseConvert adMobileResponseConvert;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected Response invokeDsp(Request request) {
        if (request == null) {
            return null;
        }
        try {
            return (Response)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.adMobileProperties.getUrl(), request), (String)"invokeDSP", (String)"AdMobile");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"AdMobile_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"AdMobile\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private Response doHttpInvoke(String url, Request request) {
        Cat.logMetricForCount((String)"ADMobile_DSP\u8c03\u7528");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        ResponseEntity resEntity = null;
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Response.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"ADMobile \u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        HttpHeaders respHeaders = resEntity.getHeaders();
        String traceId = respHeaders.getFirst("x-tm-traceid");
        Response body = (Response)resEntity.getBody();
        if (body != null && body.getCode() == 200) {
            body.setTraceId(traceId);
            Cat.logMetricForCount((String)"ADMobile_DSP\u8fd4\u56de");
            if (SamplerLog.infoFlag()) {
                SamplerLog.info((String)"", (Object[])new Object[0]);
            }
            return body;
        }
        if (SamplerLog.infoFlag()) {
            SamplerLog.info((String)"ADMobile DSP\u65e0\u5185\u5bb9\u8fd4\u56de,ADMobile Resp body {}", (Object[])new Object[]{JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)body)});
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("0276af914fee82a4".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            String s = Base64.getEncoder().encodeToString(bytes);
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            log.warn("AdMobile\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_9.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_9;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__TM_BID_PRICE__") && price != null) {
            url = url.replaceAll("__TM_BID_PRICE__", price);
        }
        return url;
    }

    @Override
    public Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.adMobileRequestConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(Response response) throws DspException {
        return this.adMobileResponseConvert.convert(response);
    }
}

