/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Ad;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.AppPromotion;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Response;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Tracker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdMobileResponseConvert {
    private static final Logger log = LoggerFactory.getLogger(AdMobileResponseConvert.class);

    public AdxCommonBidResponse convert(Response response) {
        if (response == null) {
            return null;
        }
        if (response.getCode() == null || response.getCode() != 200) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setDspId(DspEnum.DSP_9.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response);
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(Response response) {
        Tracker tracker;
        String desc;
        Ad data = response.getData();
        ArrayList<CommonSeatBid> commonSeatBids = new ArrayList<CommonSeatBid>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext commonContext = new CommonContext();
        commonSeatBid.setCommonContext(commonContext);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        Integer materialType = data.getMaterialType();
        String title = data.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(title);
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(desc = data.getDesc()))) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(desc);
            commonCreative.setCommonDesc(commonDesc);
        }
        ArrayList<CommonImage> imageList = new ArrayList<CommonImage>();
        if (CollectionUtils.isNotEmpty(data.getImageUrlList())) {
            List<String> imageUrlList = data.getImageUrlList();
            for (String s : imageUrlList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(s);
                imageList.add(commonImage);
            }
            commonCreative.setCommonImageList(imageList);
        }
        if (StringUtils.isNotBlank((CharSequence)data.getImageUrl())) {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(data.getImageUrl());
            imageList.add(commonImage);
            commonCreative.setCommonImageList(imageList);
        }
        if (data.getVideo() != null) {
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(data.getVideo().getUrl());
            commonVideo.setDuration(BigDecimal.valueOf(data.getVideo().getDuration().intValue()));
            ArrayList<CommonVideo> commonVideoList = new ArrayList<CommonVideo>();
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }
        if (Objects.equals(data.getDeeplinkType(), 0)) {
            commonContext.setDeepLinkUrl(data.getDeeplinkUrl());
        }
        if (Objects.equals(data.getDeeplinkType(), 1)) {
            commonContext.setULinkUrl(data.getDeeplinkUrl());
        }
        commonCreative.setLandingPageUrl(data.getLandingPageUrl());
        AppPromotion appPromotion = data.getAppPromotion();
        if (appPromotion != null) {
            commonCreative.setAppName(appPromotion.getAppName());
            commonCreative.setAppVersion(appPromotion.getAppVersion());
            commonCreative.setAppBundle(appPromotion.getAppBundle());
            commonCreative.setIconUrl(appPromotion.getAppIconUrl());
            commonCreative.setDeveloper(appPromotion.getAdvertiserName());
            commonCreative.setPrivacyPolicyLink(appPromotion.getPrivacyPolicyUrl());
            commonCreative.setPermissionLink(appPromotion.getPrivacyPolicyInfo());
        }
        if ((tracker = data.getTracker()) != null) {
            List<String> display = tracker.getDisplay();
            commonSeatBid.setExposureCallbackUrls(display);
            List<String> click = tracker.getClick();
            commonSeatBid.setClickCallbackUrls(click);
        }
        commonSeatBid.setPrice(data.getBidPrice().doubleValue());
        if (StringUtils.isNotBlank((CharSequence)data.getWinNoticeUrl())) {
            List<String> winCallback = Collections.singletonList(data.getWinNoticeUrl());
            commonSeatBid.setWinCallbackUrls(winCallback);
        }
        commonSeatBids.add(commonSeatBid);
        return commonSeatBids;
    }
}

