/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidResponseOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class KuaishouDspResponseConverter {
    public AdxCommonBidResponse respConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_8.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getRequestId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse rtbResponse) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        commonSeatBid.setAdvertiserId("44910");
        if (rtbResponse.getBidsList().isEmpty()) {
            return commonSeatBidList;
        }
        KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid bidResponse = rtbResponse.getBidsList().get(0);
        commonSeatBid.setPrice(Double.valueOf(bidResponse.getBidPrice()));
        commonSeatBid.setCommonCreative(this.creativeConvert(bidResponse.getCreativeDetails()));
        ArrayList<String> winCallbackUrls = new ArrayList<String>();
        winCallbackUrls.add(bidResponse.getNoticeUrl());
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        this.setExposureUrl(commonSeatBid, bidResponse.getImpressionMonitorUrl());
        this.setClickUrl(commonSeatBid, bidResponse.getClickMonitorUrl());
        commonSeatBid.setCommonContext(this.commonContextConvert(bidResponse.getCreativeDetails()));
        return commonSeatBidList;
    }

    private void setClickUrl(CommonSeatBid commonSeatBid, String clickList) {
        if (StringUtils.isBlank((CharSequence)clickList)) {
            return;
        }
        commonSeatBid.setClickCallbackUrls(Collections.singletonList(clickList));
    }

    private void setExposureUrl(CommonSeatBid commonSeatBid, String exposureUrl) {
        if (StringUtils.isBlank((CharSequence)exposureUrl)) {
            return;
        }
        commonSeatBid.setExposureCallbackUrls(Collections.singletonList(exposureUrl));
    }

    private CommonContext commonContextConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetails) {
        CommonContext commonContext = new CommonContext();
        if (StringUtils.isNotBlank((CharSequence)creativeDetails.getDeepLinkUri())) {
            commonContext.setDeepLinkUrl(creativeDetails.getDeepLinkUri());
        }
        return commonContext;
    }

    private CommonCreative creativeConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetails) {
        CommonCreative commonCreative = new CommonCreative();
        this.setLandPageUrlByAdType(creativeDetails, commonCreative);
        commonCreative.setBrandName("\u63a8\u554a");
        commonCreative.setCommonTitle(this.convertCommonTitle(creativeDetails.getTitle(), creativeDetails.getTitle()));
        commonCreative.setCommonDesc(this.commonDescConvert(creativeDetails.getDescription()));
        commonCreative.setCommonIcon(this.commonIconConvert(creativeDetails.getIcon()));
        this.commonImageOrVideoConvert(creativeDetails, commonCreative);
        commonCreative.setAppName(creativeDetails.getAppName());
        commonCreative.setAppBundle(creativeDetails.getAppPackage());
        Optional.of(creativeDetails.getIcon()).ifPresent(commonCreative::setIconUrl);
        return commonCreative;
    }

    private void setLandPageUrlByAdType(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse, CommonCreative commonCreative) {
        if (commonCreative == null) {
            return;
        }
        commonCreative.setLandingPageUrl(rtbResponse.getLandingPageUrl());
        commonCreative.setDeepLinkUrl(rtbResponse.getDeepLinkUri());
    }

    private void commonImageOrVideoConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse, CommonCreative commonCreative) {
        if (StringUtils.isBlank((CharSequence)rtbResponse.getVideoUrl())) {
            commonCreative.setCommonImageList(this.convertCommImage(rtbResponse));
        } else {
            commonCreative.setCommonVideoList(this.convertCommVideo(rtbResponse));
        }
    }

    private List<CommonVideo> convertCommVideo(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetail) {
        if (StringUtils.isBlank((CharSequence)creativeDetail.getVideoUrl())) {
            return null;
        }
        ArrayList commonVideoList = Lists.newArrayList();
        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(creativeDetail.getVideoUrl());
        commonVideo.setResolutionY(creativeDetail.getVideoHeight());
        commonVideo.setResolutionX(creativeDetail.getVideoWidth());
        commonVideo.setCoverUrl(creativeDetail.getCoverUrl());
        commonVideo.setCoverHeight(creativeDetail.getVideoHeight());
        commonVideo.setCoverWidth(creativeDetail.getVideoWidth());
        commonVideo.setDuration(new BigDecimal(creativeDetail.getVideoDuration()));
        commonVideoList.add(commonVideo);
        return commonVideoList;
    }

    private List<CommonImage> convertCommImage(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse) {
        List<KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails.image> imagesList = rtbResponse.getImagesList();
        if (CollectionUtils.isEmpty(imagesList)) {
            return null;
        }
        ArrayList commonImageList = Lists.newArrayList();
        imagesList.forEach(image2 -> {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image2.getImageUrl());
            commonImage.setHeight(image2.getImageHeight());
            commonImage.setWidth(image2.getImageWidth());
            commonImageList.add(commonImage);
        });
        return commonImageList;
    }

    private CommonIcon commonIconConvert(String iconurl) {
        if (StringUtils.isBlank((CharSequence)iconurl)) {
            return null;
        }
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconurl);
        return commonIcon;
    }

    private CommonDesc commonDescConvert(String desc) {
        CommonDesc commonDesc = new CommonDesc();
        commonDesc.setDesc(desc);
        return commonDesc;
    }

    private CommonTitle convertCommonTitle(String title, String desc) {
        CommonTitle commonTitle = new CommonTitle();
        commonTitle.setTitle(title);
        commonTitle.setSubTitle(desc);
        return commonTitle;
    }
}

