/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Image;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiRsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Video;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RuiShiRespConvert {
    public AdxCommonBidResponse convert(RuiShiRsp ruiShiRsp) {
        Bid bid = ruiShiRsp.getBid();
        if (bid == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(ruiShiRsp.getId());
        commonBidResponse.setDspId(DspEnum.DSP_11.getDspId());
        CommonSeatBid commonSeatBid = this.bidConvert(bid);
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        commonSeatBidList.add(commonSeatBid);
        commonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return commonBidResponse;
    }

    private CommonSeatBid bidConvert(Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
        commonSeatBid.setExposureCallbackUrls(bid.getImptrackers());
        commonSeatBid.setClickCallbackUrls(bid.getClicktrackers());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        String iconUrl = null;
        if (bid.getBrand_name() != null) {
            commonCreative.setAppName(bid.getBrand_name());
        }
        if (bid.getPkgname() != null) {
            commonCreative.setAppBundle(bid.getPkgname());
        }
        if (bid.getBrand_logo() != null) {
            iconUrl = bid.getBrand_logo();
        }
        if (iconUrl != null) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(iconUrl);
            commonCreative.setCommonIcon(commonIcon);
        }
        if (bid.getTitle() != null) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(bid.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (bid.getDesc() != null) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(bid.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (bid.getVideo() != null) {
            Video video = bid.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVurl());
            commonVideo.setResolutionX(video.getVw());
            commonVideo.setResolutionY(video.getVh());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getVsize());
            commonVideo.setUnit("Byte");
            List<Image> image2 = bid.getImage();
            if (CollectionUtils.isNotEmpty(image2)) {
                Image coverImg = image2.get(0);
                commonVideo.setCoverUrl(coverImg.getUrl());
                commonVideo.setCoverWidth(coverImg.getWidth());
                commonVideo.setCoverHeight(coverImg.getHeight());
            }
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<Image> imageList = bid.getImage();
            ArrayList<CommonImage> commonImages = new ArrayList<CommonImage>(imageList.size());
            for (Image image3 : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image3.getUrl());
                commonImage.setWidth(image3.getWidth());
                commonImage.setHeight(image3.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank((CharSequence)bid.getDeeplink())) {
            commonCreative.setDeepLinkUrl(bid.getDeeplink());
            context.setDeepLinkUrl(bid.getDeeplink());
        }
        if (StringUtils.isNotBlank((CharSequence)bid.getUlk_scheme())) {
            commonCreative.setULinkUrl(bid.getUlk_scheme());
            context.setULinkUrl(bid.getUlk_scheme());
        }
        commonCreative.setLandingPageUrl(bid.getLdp());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}

