/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class TanxDspInvoker
extends AbstractDspCaller<TanxBiddingResponse.Response, TanxBiddingRequest.Request> {
    private static final Logger log = LoggerFactory.getLogger(TanxDspInvoker.class);
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Autowired
    private TanxRequestConvert tanxRequestConvert;
    @Autowired
    private TanxResponseConvert tanxResponseConvert;
    @Autowired
    private TanxProperties tanxProperties;

    @Override
    protected TanxBiddingResponse.Response invokeDsp(TanxBiddingRequest.Request tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        try {
            return (TanxBiddingResponse.Response)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.tanxProperties.getUrl(), tanxBiddingRequest), (String)"invokeDSP", (String)"tanx");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"tanx_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"tanxDSP\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private TanxBiddingResponse.Response doHttpInvoke(String url, TanxBiddingRequest.Request tanxBiddingRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        HttpEntity requestEntity = new HttpEntity((Object)tanxBiddingRequest.toByteArray(), (MultiValueMap)headers);
        SamplerLog.info((String)"tanx doHttpInvoke rtbRequest:{}", (Object[])new Object[]{tanxBiddingRequest});
        Cat.logMetricForCount((String)"tanxDSP\u8c03\u7528");
        ResponseEntity resEntity = null;
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"tanxDSP\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        TanxBiddingResponse.Response response = TanxBiddingResponse.Response.parseFrom(resource.getInputStream());
        if (CollectionUtils.isNotEmpty(response.getSeatList())) {
            Cat.logMetricForCount((String)"tanxDSP\u8fd4\u56de");
        }
        return response;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("f06a2467e1669643".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            log.warn("tanx\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        TanxDspInvoker invoker = new TanxDspInvoker();
        String s = invoker.priceEncryption(new BigDecimal("10"));
        System.out.println(s);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_5.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_5;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%SETTLE_PRICE%%") && price != null) {
            url = url.replaceAll("%%SETTLE_PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public TanxBiddingRequest.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.tanxRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(TanxBiddingResponse.Response tanxBiddingResponse) throws DspException {
        try {
            return this.tanxResponseConvert.respConvert(tanxBiddingResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}

