/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.ConnectionTypeConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.OsConvert;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeviceConvert {
    public static TanxBiddingRequest.Request.Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        TanxBiddingRequest.Request.Device.Builder builder = TanxBiddingRequest.Request.Device.newBuilder();
        CommonDevice device = adxCommonBidRequest.getDevice();
        if (StringUtils.isNotBlank((CharSequence)device.getIp())) {
            builder.setIp(device.getIp());
        }
        if (StringUtils.isNotBlank((CharSequence)device.getUa())) {
            builder.setUserAgent(device.getUa());
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getImeiMd5())) {
            builder.setImeiMd5(StringUtils.upperCase((String)device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaIdMd5())) {
            builder.setOaidMd5(StringUtils.upperCase((String)device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getIdFaMd5())) {
            builder.setIdfaMd5(StringUtils.upperCase((String)device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaId())) {
            builder.setOaid(device.getOaId());
        }
        if (CollectionUtils.isNotEmpty(device.getCaids())) {
            for (Caid commonCaid : device.getCaids()) {
                TanxBiddingRequest.Request.Device.CAID.Builder caid = TanxBiddingRequest.Request.Device.CAID.newBuilder();
                caid.setCaid(commonCaid.getId());
                caid.setVer(commonCaid.getVersion());
                builder.addCaids(caid);
            }
        }
        builder.setDeviceType(0);
        if (StringUtils.isNotBlank((CharSequence)device.getMake())) {
            builder.setBrand(device.getMake());
        }
        if (StringUtils.isNotBlank((CharSequence)device.getModel())) {
            builder.setModel(device.getModel());
        }
        builder.setOs(OsConvert.getOsType(device.getOs()));
        if (StringUtils.isNotEmpty((CharSequence)device.getOsVersion())) {
            builder.setOsv(device.getOsVersion());
        }
        builder.setNetwork(ConnectionTypeConvert.convertConnectionType(device.getTuiaConnectionType()));
        return builder.build();
    }
}

