/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.RedisBalanceKeyUtil;
import cn.com.duiba.spring.boot.starter.dsp.util.RedisBloomHandler;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.QiHandProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangRealReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangResp;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class QiHangDspInvoker
extends AbstractDspCaller<QiHangResp, QiHangRealReq> {
    private static final Logger log = LoggerFactory.getLogger(QiHangDspInvoker.class);
    @Autowired
    private QiHangJsonReqConvert qiHangJsonReqConvert;
    @Autowired
    private QiHangJsonRespConvert qiHangJsonRespConvert;
    @Autowired
    private QiHandProperties qiHandProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;
    @Resource(name="redisBloom2StringRedisTemplate")
    private RedisTemplate redisTemplate;
    @Resource
    private RedisBloomHandler redisBloomHandler;
    @Autowired
    private ExecutorService executorService;
    private static final String LOCATION_DEVICE_BLOOM_PREFIX = "adx_location_device_bloom_";

    @Override
    protected QiHangResp invokeDsp(QiHangRealReq bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u542f\u822aDSP\u8c03\u7528");
        try {
            return (QiHangResp)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.qiHandProperties.getUrl(), bidRequest), (String)"invokeDSP", (String)"qihang");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u542f\u822a_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u542f\u822a\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private QiHangResp doHttpInvoke(String url, QiHangRealReq bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)bidRequest.getQiHangReq(), (MultiValueMap)headers);
        ResponseEntity resEntity = null;
        try {
            resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, QiHangResp.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("\u542f\u822a\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
            return null;
        }
        QiHangResp body = (QiHangResp)resEntity.getBody();
        if (body == null) {
            return null;
        }
        if (body.getNbr() == 9) {
            ResponseEntity finalResEntity = resEntity;
            this.executorService.execute(() -> {
                String currentDayStr = LocalDate.now().toString();
                String baseKey = StringUtils.join((Object[])new String[]{LOCATION_DEVICE_BLOOM_PREFIX, currentDayStr});
                String redisBalance8key = RedisBalanceKeyUtil.getRedisBalance8key((String)baseKey, (String)bidRequest.getTuiaDeviceId());
                this.redisBloomHandler.addString(this.redisTemplate, redisBalance8key, bidRequest.getTuiaDeviceId());
                SamplerLog.info((String)"\u542f\u822a \u5199\u5165\u9ed1\u540d\u5355 {}", (Object[])new Object[]{finalResEntity});
            });
        }
        if (CollectionUtils.isEmpty(body.getSeat_bid())) {
            return null;
        }
        Cat.logMetricForCount((String)"\u542f\u822aDSP\u8fd4\u56de");
        return body;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("BzABOvVhLYJiuo3Y".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex);
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.warn("\u542f\u822a\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_10.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_10;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replaceAll("\\$\\{AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public QiHangRealReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.qiHangJsonReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(QiHangResp bidResponse) throws DspException {
        return this.qiHangJsonRespConvert.convert(bidResponse);
    }
}

