/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;

@Service
public class StringRedisHandler {
    @Resource(name="redis03StringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;

    public StringRedisTemplate getTemplateInstance() {
        return this.stringRedisTemplate;
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public void set(String key, String value, long timeout, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public void append(String key, String value) {
        this.stringRedisTemplate.opsForValue().append((Object)key, value);
    }

    public Long increment(String key, long delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Double increment(String key, double delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.stringRedisTemplate.expire((Object)key, timeout, unit);
    }

    public Long getExpire(String key, TimeUnit unit) {
        return this.stringRedisTemplate.getExpire((Object)key, unit);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public void delete(List<String> keyList) {
        this.stringRedisTemplate.delete(keyList);
    }

    public Boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public Boolean expireAt(String key, Date date) {
        return this.stringRedisTemplate.expireAt((Object)key, date);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public Object hoGet(String key, Object hashKey) {
        return this.stringRedisTemplate.opsForHash().get((Object)key, hashKey);
    }

    public Long hoIncrement(String key, Object hashKey, long delta) {
        return this.stringRedisTemplate.opsForHash().increment((Object)key, hashKey, delta);
    }

    public Map<Object, Object> hoEntries(String key) {
        return this.stringRedisTemplate.opsForHash().entries((Object)key);
    }

    public void hoPut(String key, Object hashKey, String value) {
        this.stringRedisTemplate.opsForHash().put((Object)key, hashKey, (Object)value);
    }

    public void hoPutAll(String key, Map<String, String> map) {
        this.stringRedisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Boolean zsoAdd(String key, String value, double score) {
        return this.stringRedisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public Set<String> zsoRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<String>> zsoRangeByScoreWithScores(String key, double min, double max) {
        return this.stringRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }

    public Boolean soIsMember(String key, Object o) {
        return this.stringRedisTemplate.opsForSet().isMember((Object)key, o);
    }

    public Set<String> soMembers(String key) {
        return this.stringRedisTemplate.opsForSet().members((Object)key);
    }

    public Long soSize(String key) {
        return this.stringRedisTemplate.opsForSet().size((Object)key);
    }

    public Long soRemove(String key, Object ... values) {
        return this.stringRedisTemplate.opsForSet().remove((Object)key, values);
    }

    public Long soAdd(String key, String ... values) {
        return this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public Long loRightPush(String key, String value) {
        return this.stringRedisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public List<String> loRange(String key, long start, long end) {
        return this.stringRedisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long loLeftPush(String key, String value) {
        return this.stringRedisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public void loTrim(String key, long start, long end) {
        this.stringRedisTemplate.opsForList().trim((Object)key, start, end);
    }

    public Map<String, Map<String, String>> pipelineHget(final List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> valuesMap = new HashMap<String, Map<String, String>>(keys.size());
        List pipResults = this.stringRedisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.opsForHash().entries((Object)key);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            Map valMap = (Map)pipResult;
            HashMap hMap = new HashMap();
            valMap.forEach((vkey, val) -> {
                if (vkey != null && val != null) {
                    hMap.put(vkey.toString(), val.toString());
                }
            });
            valuesMap.put(key, hMap);
        }
        return valuesMap;
    }

    public Map<String, String> pipelineValue(final List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> valueMap = new HashMap<String, String>(keys.size());
        List pipResults = this.stringRedisTemplate.executePipelined((SessionCallback)new SessionCallback<Object>(){

            public <K, V> Object execute(RedisOperations<K, V> operations) throws DataAccessException {
                StringRedisTemplate template = (StringRedisTemplate)operations;
                for (String key : keys) {
                    template.opsForValue().get((Object)key);
                }
                return null;
            }
        });
        for (int index = 0; index < keys.size(); ++index) {
            Object pipResult = pipResults.get(index);
            String key = keys.get(index);
            if (pipResult == null) continue;
            valueMap.put(key, pipResult.toString());
        }
        return valueMap;
    }

    public String hGetAll(String key) {
        Map entries = this.stringRedisTemplate.opsForHash().entries((Object)key);
        return JSONObject.toJSONString((Object)entries);
    }
}

