/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtils {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    public static String sign(String metadata, String key) throws SecurityException {
        try {
            return SignatureUtils.sign(metadata.getBytes(), key);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to generate HMAC : " + e.getMessage(), e);
        }
    }

    public static String sign(Object[] parameters, String metadata, String key) {
        try {
            if (parameters == null) {
                return SignatureUtils.sign(metadata, key);
            }
            boolean notSerializable = Arrays.stream(parameters).anyMatch(parameter -> !(parameter instanceof Serializable));
            if (notSerializable) {
                throw new IllegalArgumentException("");
            }
            Object[] includeMetadata = new Object[parameters.length + 1];
            System.arraycopy(parameters, 0, includeMetadata, 0, parameters.length);
            includeMetadata[parameters.length] = metadata;
            byte[] bytes = SignatureUtils.toByteArray(includeMetadata);
            return SignatureUtils.sign(bytes, key);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to generate HMAC : " + e.getMessage(), e);
        }
    }

    public static String sign(byte[] data, String key) throws SignatureException {
        String result;
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data);
            result = Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] toByteArray(Object[] parameters) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(parameters);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

