/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ClientInterceptor;
import org.apache.dubbo.rpc.protocol.grpc.interceptors.ServerInterceptor;

@Activate(group={"provider", "consumer"})
public class RpcContextInterceptor
implements ClientInterceptor,
ServerInterceptor {
    private static final String DUBBO = "D-";

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        RpcContextAttachment rpcContext = RpcContext.getClientAttachment();
        final HashMap attachments = new HashMap(rpcContext.getObjectAttachments());
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (!attachments.isEmpty()) {
                    for (Map.Entry entry : attachments.entrySet()) {
                        if (!(entry.getValue() instanceof String)) continue;
                        headers.put(Metadata.Key.of((String)(RpcContextInterceptor.DUBBO + (String)entry.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)((String)entry.getValue()));
                    }
                }
                super.start(responseListener, headers);
            }
        };
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Set keys = headers.keys();
        final HashMap attachments = new HashMap();
        if (keys != null) {
            keys.stream().filter(k -> k.toUpperCase().startsWith(DUBBO)).forEach(k -> attachments.put(k.substring(DUBBO.length()), headers.get(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))));
        }
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onHalfClose() {
                if (call.getMethodDescriptor().getType().clientSendsOneMessage()) {
                    RpcContext.getServerAttachment().setObjectAttachments(attachments);
                }
                super.onHalfClose();
            }

            public void onMessage(ReqT message) {
                if (!call.getMethodDescriptor().getType().clientSendsOneMessage()) {
                    RpcContext.getServerAttachment().setObjectAttachments(attachments);
                }
                super.onMessage(message);
            }
        };
    }
}

