/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.cache.support.lru;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.common.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache
implements Cache {
    private final Map<Object, Object> store;

    public LruCache(URL url) {
        final int max = url.getParameter("cache.size", 1000);
        this.store = new LinkedHashMap<Object, Object>(){
            private static final long serialVersionUID = -3834209229668463829L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
                return this.size() > max;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object value) {
        Map<Object, Object> map = this.store;
        synchronized (map) {
            this.store.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Map<Object, Object> map = this.store;
        synchronized (map) {
            return this.store.get(key);
        }
    }
}

