package cn.com.duiba.api.bo.mq;

import cn.com.duiba.api.tools.GZIPCompressUtil;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/**
 * 发送钉钉消息文本类型
 * @author sunchangji on 2018/11/14.
 */
public class DingTextMessage implements Serializable {
    private static final long serialVersionUID = 783264283090818698L;

    /**
     * 钉钉群机器人token
     */
    private String dingToken;

    /**
     * 消息内容
     */
    private String content;

    /**
     * 是否需要at所有人,true会at群里所有人,false不会
     */
    private Boolean toAtAll;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Boolean getToAtAll() {
        return toAtAll;
    }

    public void setToAtAll(Boolean toAtAll) {
        this.toAtAll = toAtAll;
    }

    public String getDingToken() {
        return dingToken;
    }

    public void setDingToken(String dingToken) {
        this.dingToken = dingToken;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static DingTextMessage decode(byte[] msg) {
        String string = GZIPCompressUtil.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, DingTextMessage.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param dingTextMessage
     * @return
     */
    public static byte[] encode(DingTextMessage dingTextMessage) {
        String string = JSONObject.toJSONString(dingTextMessage);
        try {
            byte[] str = string.getBytes("utf-8");
            return GZIPCompressUtil.gzip(str);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

