package cn.com.duiba.api.bo.custom.iqiyicustom;

import javax.validation.Valid;
import org.hibernate.validator.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Description: 爱奇艺活动配置定制页VO, 爱奇艺活动配置定制页，2019.03.01 后可联系产品@成煜，确认是否可以移除
 * @Author: fxr
 * @Date: 2018/12/25
 */
public class IqiyiActivityConfDto implements Serializable {
    private static final long serialVersionUID = 1585198036035816998L;

    /**
     *  爱奇艺端内抽卡配置
     */
    @Valid
    @NotEmpty(message = "爱奇艺-端内抽卡配置项缺失")
    private List<ClientDrawCardDto> clientDrawCards;

    /**
     *  爱奇艺助力抽卡配置
     */
    @Valid
    @NotEmpty(message = "爱奇艺-助力抽卡配置项缺失")
    private List<HelpDrawCardDto> helpDrawCards;

    /**
     *  爱奇艺被助力抽卡配置
     */
    @Valid
    @NotEmpty(message = "爱奇艺-被助力抽卡配置项缺失")
    private List<ByHelpDrawCardDto> byHelpDrawCards;

    /**
     *  爱奇艺红包雨抽卡配置
     */
    @Valid
    @NotEmpty(message = "爱奇艺-红包雨抽卡配置项缺失")
    private List<RedRainDrawCardDto> redRainDrawCards;

    /**
     *  参与作弊人数
     */
    @NotNull(message = "爱奇艺-参与作弊人数配置项缺失")
    private Long cheatingNum;

    public List<ClientDrawCardDto> getClientDrawCards() {
        return clientDrawCards;
    }

    public void setClientDrawCards(List<ClientDrawCardDto> clientDrawCards) {
        this.clientDrawCards = clientDrawCards;
    }

    public List<HelpDrawCardDto> getHelpDrawCards() {
        return helpDrawCards;
    }

    public void setHelpDrawCards(List<HelpDrawCardDto> helpDrawCards) {
        this.helpDrawCards = helpDrawCards;
    }

    public List<ByHelpDrawCardDto> getByHelpDrawCards() {
        return byHelpDrawCards;
    }

    public void setByHelpDrawCards(List<ByHelpDrawCardDto> byHelpDrawCards) {
        this.byHelpDrawCards = byHelpDrawCards;
    }

    public List<RedRainDrawCardDto> getRedRainDrawCards() {
        return redRainDrawCards;
    }

    public void setRedRainDrawCards(List<RedRainDrawCardDto> redRainDrawCards) {
        this.redRainDrawCards = redRainDrawCards;
    }

    public Long getCheatingNum() {
        return cheatingNum;
    }

    public void setCheatingNum(Long cheatingNum) {
        this.cheatingNum = cheatingNum;
    }
}

