package cn.com.duiba.api.enums;

/**
 * @author zhengjianhao
 * @date 18/12/4
 * @description
 */
public enum GoodsTypeEnum {
	DUIBA(1, "兑吧商品"),
	APP(2, "app自有商品"),
	PLATFORM(3, "平台券商品"),
	ADVERT(4, "广告券商品"),
	MAILA(5, "麦啦商品");

	private int gtype;
	private String desc;

	private GoodsTypeEnum(int gtype, String desc) {
		this.gtype = gtype;
		this.desc = desc;
	}

	public int getGtype() {
		return this.gtype;
	}

	public String getDesc() {
		return this.desc;
	}

	public static GoodsTypeEnum getGoodsTypeEnum(int type) {
		GoodsTypeEnum[] values = values();
		GoodsTypeEnum[] arr = values;
		int len = values.length;

		for(int i = 0; i < len; ++i) {
			GoodsTypeEnum value = arr[i];
			if (value.getGtype() == type) {
				return value;
			}
		}

		return null;
	}
}