package cn.com.duiba.api.enums.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @program: supplier-center
 * @description: 物流公司枚举
 * @author: Simba
 * @create: 2018-12-12 15:10
 **/
public enum LogisticsCompanyEnum {

    YTO("YTO", "圆通速递"),
    STO("STO", "申通快递"),
    SF("SF", "顺丰速运"),
    ZTO("ZTO", "中通快递"),
    ZJS("ZJS", "宅急送"),
    YUNDA("YUNDA", "韵达快递"),
    TTKDEX("TTKDEX", "天天快递"),
    HTKY("HTKY", "百世汇通"),
    EYB(" EYB", "EMS经济快递"),
    EMS("EMS", "EMS"),
    FAST("FAST", "快捷快递"),
    UC("UC", "优速快递"),
    GTO("GTO", "国通快递"),
    QFKD("QFKD", "全峰快递"),
    DBKD("DBKD", "德邦物流"),
    XFEX("XFEX", "信丰物流"),
    ANE("ANE", "安能快递"),
    JD("JD", "京东快递"),
    OTHERS("OTHERS", "其他"),

    // 暂与开发者后台物流信息保持一致
//    POSTB("POSTB", "中国邮政快递包裹"),
//    BESTQJT("BESTQJT", "百世快运"),
//    RFD("RFD", "如风达"),
    ;

    public static final ImmutableMap<String, LogisticsCompanyEnum> LOGISTICS_NAME_MAP;

    static {
        Map<String, LogisticsCompanyEnum> temp = Maps.newHashMap();
        for (LogisticsCompanyEnum logistics : values()) {
            temp.put(logistics.getName(), logistics);
        }
        LOGISTICS_NAME_MAP = ImmutableMap.copyOf(temp);
    }

    private String code;

    private String name;

    LogisticsCompanyEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() { return name; }
}

