package cn.com.duiba.api.enums.subcredits;

/**
 * @author zhangruofan
 * @date 2018/06/22
 */
public enum SubCreditsOuterType {
    /**
     * 支付宝
     */
    ALIPAY("alipay", "支付宝"),

    /**
     * Q币
     */
    QB("qb", "Q币"),

    /**
     * 优惠券
     */
    COUPON("coupon", "优惠券"),

    /**
     * 实物
     */
    OBJECT("object", "实物"),

    /**
     * 话费
     */
    PHONE_BILL("phonebill", "话费"),

    /**
     * 流量
     */
    PHONE_FLOW("phoneflow", "流量"),

    /**
     * 虚拟商品
     */
    VIRTUAL("virtual", "虚拟商品"),

    /**
     * 游戏
     */
    GAME("game", "游戏"),

    /**
     * 所有活动
     */
    HDTOOL("hdtool", "活动工具"),

    /**
     * 签到
     */
    SIGN("sign", "签到")
    ;

    private String code;
    private String desc;

    SubCreditsOuterType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }
}
