package cn.com.duiba.api.bo;

import java.io.Serializable;

/**
 * Created by xukaiqiang 2018/5/29
 */
public class BizResultDto<T> implements Serializable {

    private static final long serialVersionUID = -6546422617495336241L;

    private static final String SUCCESS_MSG = "请求成功";

    /* 返回码 */
    private Boolean success;
    /* 错误信息码 */
    private String code;
    /* 提示信息 */
    private String msg;
    /* 具体的内容 */
    private T data;

    private BizResultDto(){}

    public Boolean isSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> BizResultDto<T> success(T t) {
        BizResultDto<T> dto = new BizResultDto<>();
        dto.setSuccess(true);
        dto.setMsg(SUCCESS_MSG);
        dto.setData(t);
        return dto;
    }

    public static BizResultDto success() {
        BizResultDto dto = new BizResultDto();
        dto.setSuccess(true);
        dto.setMsg(SUCCESS_MSG);
        return dto;
    }

    public static <T> BizResultDto<T> fail(String code, String msg) {
        BizResultDto<T> dto = new BizResultDto<>();
        dto.setCode(code);
        dto.setMsg(msg);
        dto.setSuccess(false);
        return dto;
    }

    public static <T> BizResultDto<T> fail(String msg) {
        BizResultDto<T> dto = new BizResultDto<>();
        dto.setMsg(msg);
        dto.setSuccess(false);
        return dto;
    }

}


