package cn.com.duiba.api.enums;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br/>
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 *
 */
public enum RedisKeySpace {
	/** 爱奇艺红包任务用户解锁的人数 */
	K001("爱奇艺红包任务用户解锁的人数"),
	/** 爱奇艺红包任务用户信息 */
	K002("爱奇艺红包任务用户信息"),
	/** 爱奇艺红包任务用户开奖状态 */
	K003("爱奇艺红包任务用户开奖状态"),

	K004("爱奇艺8月活动奖金池"),

	K005("爱奇艺8月活动已发放金额"),

	K006("爱奇艺8月活动可提现金额"),

	K007("爱奇艺8月活动已提现金额"),

	K008("爱奇艺8月活动奖项配置"),

	K009("爱奇艺8月活动opId"),

	K010("爱奇艺8月活动Id"),

	K011("爱奇艺8月活动appId"),

	K012("爱奇艺8月活动插件活动Id"),

	K013("爱奇艺8月活动用户详情"),

	K014("风控全局开关"),

	K015("陌陌集卡奖项配置"),

	K016("陌陌用户是否绑定过邀请码"),

	K017("陌陌集卡活动每期标识"),
	K018("陌陌集卡活动抽奖次数标识"),
	K019("陌陌集卡活动分享每日加次数限制"),

	K020("陌陌集卡已中奖用户"),
	K021("陌陌集卡每日免费抽奖次数标识"),
	K022("陌陌集卡每期开始时间戳"),

	K055("猜红包用户最近开的红包"),
	K056("猜红包用户红包信息"),

	K057("优酷用户加次数分享信息"),

	K058("投票活动参赛者"),

	K059("美篇签到幸运大奖得主（666大红包)"),

	K060("新东方点赞排行榜"),

	K061("新东方排行榜开奖"),

	K062("盈盈有钱用户中红包个数"),

	K063("qq音乐刮刮卡累计消耗积分"),

	K064("爱奇艺用户某张卡片增加的数量"),

	K065("爱奇艺用户某张卡片的数量"),

	K066("爱奇艺累计集齐卡人数"),

	K067("爱奇艺锦鲤池"),

	K068("爱奇艺H卡库存"),

	K069("爱奇艺每个锦鲤的订单号"),

	K070("爱奇艺累计发奖金额"),

	K071("爱奇艺累计用户提现金额"),

	K072("爱奇艺每日集齐卡片人数定时任务"),

	K073("爱奇艺用户是否领过锦鲤奖励"),

	K074("爱奇艺用户是否领过集卡大奖"),

	K075("搬砖工每天登陆"),

	K076("各级搬砖工每天召唤次数"),

	K077("搬砖活动奖品已领奖个数"),

	K078("搬砖活动实物库存不足发送邮件"),

	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "biz_tool";

	private String desc;

	RedisKeySpace(String description) {
		this.desc = description;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 拼接key前置
	 */
	@Override
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}