package cn.com.duiba.api.bo.mq;

import cn.com.duiba.api.tools.GZIPCompressUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.io.UnsupportedEncodingException;

/**
 * thirdparty通过mq发送email消息体
 */
public class EmailMsg {
    /**
     * 收件人
     */
    private String receiver;

    /**
     * 主题
     */
    private String subject;

    /**
     * 正文
     */
    private String html;

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static EmailMsg decode(byte[] msg) {
        String string = GZIPCompressUtil.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, EmailMsg.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param subCreditsMsg
     * @return
     */
    public static byte[] encode(EmailMsg subCreditsMsg) {
        String string = JSONObject.toJSONString(subCreditsMsg);
        try {
            return GZIPCompressUtil.gzip(string.getBytes("utf-8"));
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
